/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.features.DomainAccountAsyncClient;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateAccountOptions;
import org.jclouds.cloudstack.options.UpdateAccountOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalAccountAsyncClient
extends DomainAccountAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"createAccount"})
    @SelectJson(value="account")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Account> createAccount(@QueryParam(value="username") String var1, @QueryParam(value="accounttype") Account.Type var2, @QueryParam(value="email") String var3, @QueryParam(value="firstname") String var4, @QueryParam(value="lastname") String var5, @QueryParam(value="password") String var6, CreateAccountOptions ... var7);

    @GET
    @QueryParams(keys={"command"}, values={"updateAccount"})
    @SelectJson(value="account")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Account> updateAccount(@QueryParam(value="account") String var1, @QueryParam(value="domainid") String var2, @QueryParam(value="newname") String var3, UpdateAccountOptions ... var4);

    @GET
    @QueryParams(keys={"command"}, values={"deleteAccount"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteAccount(@QueryParam(value="id") String var1);
}

