/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;

@Singleton
public class GetFirewallRulesByVirtualMachine
extends CacheLoader<String, Set<FirewallRule>> {
    private final CloudStackClient client;

    @Inject
    public GetFirewallRulesByVirtualMachine(CloudStackClient client) {
        this.client = (CloudStackClient)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    public Set<FirewallRule> load(String input) {
        String publicIPId = this.client.getVirtualMachineClient().getVirtualMachine(input).getPublicIPId();
        ImmutableSet rules = this.client.getFirewallClient().listFirewallRules(ListFirewallRulesOptions.Builder.ipAddressId(publicIPId));
        return rules != null ? rules : ImmutableSet.of();
    }
}

