/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.LoadBalancerRule;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.domain.User;

public class CloudStackParserModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Map<Type, Object>>(){}).toInstance((Object)ImmutableMap.of(Account.class, (Object)new BreakGenericSetAdapter(), LoadBalancerRule.class, (Object)new LoadBalancerRuleAdapter(), PortForwardingRule.class, (Object)new PortForwardingRuleAdapter(), FirewallRule.class, (Object)new FirewallRuleAdapter()));
    }

    @Singleton
    public static class BreakGenericSetAdapter
    implements JsonSerializer<Account>,
    JsonDeserializer<Account> {
        public JsonElement serialize(Account src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src);
        }

        public Account deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.apply((AccountInternal)context.deserialize(json, AccountInternal.class));
        }

        public Account apply(AccountInternal in) {
            return ((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)((Account.Builder)Account.builder().id(in.id)).type(in.type)).domain(in.domain)).domainId(in.domainId)).IPsAvailable(BreakGenericSetAdapter.nullIfUnlimited(in.IPsAvailable))).IPLimit(BreakGenericSetAdapter.nullIfUnlimited(in.IPLimit))).IPs(in.IPs)).cleanupRequired(in.cleanupRequired)).name(in.name)).receivedBytes(in.receivedBytes)).sentBytes(in.sentBytes)).snapshotsAvailable(BreakGenericSetAdapter.nullIfUnlimited(in.snapshotsAvailable))).snapshotLimit(BreakGenericSetAdapter.nullIfUnlimited(in.snapshotLimit))).snapshots(in.snapshots)).state(in.state)).templatesAvailable(BreakGenericSetAdapter.nullIfUnlimited(in.templatesAvailable))).templateLimit(BreakGenericSetAdapter.nullIfUnlimited(in.templateLimit))).templates(in.templates)).VMsAvailable(BreakGenericSetAdapter.nullIfUnlimited(in.VMsAvailable))).VMLimit(BreakGenericSetAdapter.nullIfUnlimited(in.VMLimit))).VMsRunning(in.VMsRunning)).VMsStopped(in.VMsStopped)).VMs(in.VMs)).volumesAvailable(BreakGenericSetAdapter.nullIfUnlimited(in.volumesAvailable))).volumeLimit(BreakGenericSetAdapter.nullIfUnlimited(in.volumeLimit))).volumes(in.volumes)).users(in.users)).build();
        }

        private static Long nullIfUnlimited(String in) {
            return in == null || "Unlimited".equals(in) ? null : new Long(in);
        }

        static final class AccountInternal {
            private String id;
            @SerializedName(value="accounttype")
            private Account.Type type;
            private String domain;
            @SerializedName(value="domainid")
            private String domainId;
            @SerializedName(value="ipavailable")
            private String IPsAvailable;
            @SerializedName(value="iplimit")
            private String IPLimit;
            @SerializedName(value="iptotal")
            private long IPs;
            @SerializedName(value="iscleanuprequired")
            private boolean cleanupRequired;
            private String name;
            @SerializedName(value="receivedbytes")
            private long receivedBytes;
            @SerializedName(value="sentbytes")
            private long sentBytes;
            @SerializedName(value="snapshotavailable")
            private String snapshotsAvailable;
            @SerializedName(value="snapshotlimit")
            private String snapshotLimit;
            @SerializedName(value="snapshottotal")
            private long snapshots;
            @SerializedName(value="state")
            private Account.State state;
            @SerializedName(value="templateavailable")
            private String templatesAvailable;
            @SerializedName(value="templatelimit")
            private String templateLimit;
            @SerializedName(value="templatetotal")
            private long templates;
            @SerializedName(value="vmavailable")
            private String VMsAvailable;
            @SerializedName(value="vmlimit")
            private String VMLimit;
            @SerializedName(value="vmrunning")
            private long VMsRunning;
            @SerializedName(value="vmstopped")
            private long VMsStopped;
            @SerializedName(value="vmtotal")
            private long VMs;
            @SerializedName(value="volumeavailable")
            private String volumesAvailable;
            @SerializedName(value="volumelimit")
            private String volumeLimit;
            @SerializedName(value="volumetotal")
            private long volumes;
            @SerializedName(value="user")
            private Set<User> users;

            AccountInternal() {
            }
        }
    }

    @Singleton
    public static class LoadBalancerRuleAdapter
    implements JsonSerializer<LoadBalancerRule>,
    JsonDeserializer<LoadBalancerRule> {
        public JsonElement serialize(LoadBalancerRule src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src);
        }

        public LoadBalancerRule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.apply((LoadBalancerRuleInternal)context.deserialize(json, LoadBalancerRuleInternal.class));
        }

        public LoadBalancerRule apply(LoadBalancerRuleInternal in) {
            HashSet cidrSet = Sets.newHashSet((Object[])in.CIDRs.split(","));
            return ((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)((LoadBalancerRule.Builder)LoadBalancerRule.builder().id(in.id)).account(in.account)).algorithm(in.algorithm)).description(in.description)).domain(in.domain)).domainId(in.domainId)).name(in.name)).privatePort(in.privatePort)).publicIP(in.publicIP)).publicIPId(in.publicIPId)).publicPort(in.publicPort)).state(in.state)).CIDRs(cidrSet)).zoneId(in.zoneId)).build();
        }

        static final class LoadBalancerRuleInternal {
            private String id;
            private String account;
            private LoadBalancerRule.Algorithm algorithm;
            private String description;
            private String domain;
            @SerializedName(value="domainid")
            private String domainId;
            private String name;
            @SerializedName(value="privateport")
            private int privatePort;
            @SerializedName(value="publicip")
            private String publicIP;
            @SerializedName(value="publicipid")
            private String publicIPId;
            @SerializedName(value="publicport")
            private int publicPort;
            private LoadBalancerRule.State state;
            @SerializedName(value="cidrlist")
            private String CIDRs;
            @SerializedName(value="zoneId")
            private String zoneId;

            LoadBalancerRuleInternal() {
            }
        }
    }

    @Singleton
    public static class FirewallRuleAdapter
    implements JsonSerializer<FirewallRule>,
    JsonDeserializer<FirewallRule> {
        public JsonElement serialize(FirewallRule src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src);
        }

        public FirewallRule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.apply((FirewallRuleInternal)context.deserialize(json, FirewallRuleInternal.class));
        }

        public FirewallRule apply(FirewallRuleInternal in) {
            TreeSet cidrSet;
            if (in.CIDRs != null) {
                String[] elements = in.CIDRs.split(",");
                cidrSet = Sets.newTreeSet(Arrays.asList(elements));
            } else {
                cidrSet = Collections.emptySet();
            }
            return ((FirewallRule.Builder)((FirewallRule.Builder)((FirewallRule.Builder)((FirewallRule.Builder)((FirewallRule.Builder)((FirewallRule.Builder)((FirewallRule.Builder)((FirewallRule.Builder)((FirewallRule.Builder)((FirewallRule.Builder)FirewallRule.builder().id(in.id)).CIDRs(cidrSet)).startPort(in.startPort)).endPort(in.endPort)).icmpCode(in.icmpCode)).icmpType(in.icmpType)).ipAddress(in.ipAddress)).ipAddressId(in.ipAddressId)).protocol(in.protocol)).state(in.state)).build();
        }

        static final class FirewallRuleInternal {
            private String id;
            @SerializedName(value="cidrlist")
            private String CIDRs;
            @SerializedName(value="startport")
            private int startPort;
            @SerializedName(value="endport")
            private int endPort;
            @SerializedName(value="icmpcode")
            private String icmpCode;
            @SerializedName(value="icmptype")
            private String icmpType;
            @SerializedName(value="ipaddress")
            private String ipAddress;
            @SerializedName(value="ipaddressid")
            private String ipAddressId;
            private FirewallRule.Protocol protocol;
            private FirewallRule.State state;

            FirewallRuleInternal() {
            }
        }
    }

    @Singleton
    public static class PortForwardingRuleAdapter
    implements JsonSerializer<PortForwardingRule>,
    JsonDeserializer<PortForwardingRule> {
        public JsonElement serialize(PortForwardingRule src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src);
        }

        public PortForwardingRule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.apply((PortForwardingRuleInternal)context.deserialize(json, PortForwardingRuleInternal.class));
        }

        public PortForwardingRule apply(PortForwardingRuleInternal in) {
            TreeSet cidrSet;
            if (in.CIDRs != null) {
                String[] elements = in.CIDRs.split(",");
                cidrSet = Sets.newTreeSet(Arrays.asList(elements));
            } else {
                cidrSet = Collections.emptySet();
            }
            return ((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)((PortForwardingRule.Builder)PortForwardingRule.builder().id(in.id)).IPAddress(in.IPAddress)).IPAddressId(in.IPAddressId)).privatePort(in.privatePort)).protocol(in.protocol)).publicPort(in.publicPort)).state(in.state)).virtualMachineDisplayName(in.virtualMachineDisplayName)).virtualMachineId(in.virtualMachineId)).virtualMachineName(in.virtualMachineName)).CIDRs(cidrSet)).privateEndPort(in.privateEndPort)).publicEndPort(in.publicEndPort)).build();
        }

        static final class PortForwardingRuleInternal {
            private String id;
            @SerializedName(value="ipaddress")
            private String IPAddress;
            @SerializedName(value="ipaddressid")
            private String IPAddressId;
            @SerializedName(value="privateport")
            private int privatePort;
            private PortForwardingRule.Protocol protocol;
            @SerializedName(value="publicport")
            public int publicPort;
            private PortForwardingRule.State state;
            @SerializedName(value="virtualmachinedisplayname")
            private String virtualMachineDisplayName;
            @SerializedName(value="virtualmachineid")
            public String virtualMachineId;
            @SerializedName(value="virtualmachinename")
            private String virtualMachineName;
            @SerializedName(value="cidrlist")
            private String CIDRs;
            @SerializedName(value="privateendport")
            private int privateEndPort;
            @SerializedName(value="publicendport")
            private int publicEndPort;

            PortForwardingRuleInternal() {
            }
        }
    }
}

