/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class ApiKeyPair {
    @Named(value="apikey")
    private final String apiKey;
    @Named(value="secretkey")
    private final String secretKey;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromApiKeyPair(this);
    }

    @ConstructorProperties(value={"apikey", "secretkey"})
    protected ApiKeyPair(@Nullable String apiKey, @Nullable String secretKey) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    @Nullable
    public String getApiKey() {
        return this.apiKey;
    }

    @Nullable
    public String getSecretKey() {
        return this.secretKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.apiKey, this.secretKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiKeyPair that = (ApiKeyPair)ApiKeyPair.class.cast(obj);
        return Objects.equal((Object)this.apiKey, (Object)that.apiKey) && Objects.equal((Object)this.secretKey, (Object)that.secretKey);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("apiKey", (Object)this.apiKey).add("secretKey", (Object)this.secretKey);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String apiKey;
        protected String secretKey;

        protected abstract T self();

        public T apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this.self();
        }

        public T secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this.self();
        }

        public ApiKeyPair build() {
            return new ApiKeyPair(this.apiKey, this.secretKey);
        }

        public T fromApiKeyPair(ApiKeyPair in) {
            return ((Builder)this.apiKey(in.getApiKey())).secretKey(in.getSecretKey());
        }
    }
}

