/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class VlanIPRange
implements Comparable<VlanIPRange> {
    private final String id;
    private final String description;
    @Named(value="forvirtualnetwork")
    private final boolean forVirtualNetwork;
    @Named(value="zoneid")
    private final String zoneId;
    private final String vlan;
    private final String account;
    @Named(value="domainid")
    private final String domainId;
    private final String domain;
    @Named(value="podid")
    private final String podId;
    @Named(value="podname")
    private final String podName;
    private final String gateway;
    private final String netmask;
    @Named(value="startip")
    private final String startIP;
    @Named(value="endip")
    private final String endIP;
    @Named(value="networkid")
    private final String networkId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVlanIPRange(this);
    }

    @ConstructorProperties(value={"id", "description", "forvirtualnetwork", "zoneid", "vlan", "account", "domainid", "domain", "podid", "podname", "gateway", "netmask", "startip", "endip", "networkid"})
    protected VlanIPRange(String id, @Nullable String description, boolean forVirtualNetwork, @Nullable String zoneId, @Nullable String vlan, @Nullable String account, @Nullable String domainId, @Nullable String domain, @Nullable String podId, @Nullable String podName, @Nullable String gateway, @Nullable String netmask, @Nullable String startIP, @Nullable String endIP, @Nullable String networkId) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.description = description;
        this.forVirtualNetwork = forVirtualNetwork;
        this.zoneId = zoneId;
        this.vlan = vlan;
        this.account = account;
        this.domainId = domainId;
        this.domain = domain;
        this.podId = podId;
        this.podName = podName;
        this.gateway = gateway;
        this.netmask = netmask;
        this.startIP = startIP;
        this.endIP = endIP;
        this.networkId = networkId;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isForVirtualNetwork() {
        return this.forVirtualNetwork;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getVlan() {
        return this.vlan;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getPodId() {
        return this.podId;
    }

    @Nullable
    public String getPodName() {
        return this.podName;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    @Nullable
    public String getNetmask() {
        return this.netmask;
    }

    @Nullable
    public String getStartIP() {
        return this.startIP;
    }

    @Nullable
    public String getEndIP() {
        return this.endIP;
    }

    @Nullable
    public String getNetworkId() {
        return this.networkId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.description, this.forVirtualNetwork, this.zoneId, this.vlan, this.account, this.domainId, this.domain, this.podId, this.podName, this.gateway, this.netmask, this.startIP, this.endIP, this.networkId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VlanIPRange that = (VlanIPRange)VlanIPRange.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.forVirtualNetwork, (Object)that.forVirtualNetwork) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.vlan, (Object)that.vlan) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.podId, (Object)that.podId) && Objects.equal((Object)this.podName, (Object)that.podName) && Objects.equal((Object)this.gateway, (Object)that.gateway) && Objects.equal((Object)this.netmask, (Object)that.netmask) && Objects.equal((Object)this.startIP, (Object)that.startIP) && Objects.equal((Object)this.endIP, (Object)that.endIP) && Objects.equal((Object)this.networkId, (Object)that.networkId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("description", (Object)this.description).add("forVirtualNetwork", this.forVirtualNetwork).add("zoneId", (Object)this.zoneId).add("vlan", (Object)this.vlan).add("account", (Object)this.account).add("domainId", (Object)this.domainId).add("domain", (Object)this.domain).add("podId", (Object)this.podId).add("podName", (Object)this.podName).add("gateway", (Object)this.gateway).add("netmask", (Object)this.netmask).add("startIP", (Object)this.startIP).add("endIP", (Object)this.endIP).add("networkId", (Object)this.networkId);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(VlanIPRange other) {
        return this.id.compareTo(other.id);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String description;
        protected boolean forVirtualNetwork;
        protected String zoneId;
        protected String vlan;
        protected String account;
        protected String domainId;
        protected String domain;
        protected String podId;
        protected String podName;
        protected String gateway;
        protected String netmask;
        protected String startIP;
        protected String endIP;
        protected String networkId;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T forVirtualNetwork(boolean forVirtualNetwork) {
            this.forVirtualNetwork = forVirtualNetwork;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T vlan(String vlan) {
            this.vlan = vlan;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T podId(String podId) {
            this.podId = podId;
            return this.self();
        }

        public T podName(String podName) {
            this.podName = podName;
            return this.self();
        }

        public T gateway(String gateway) {
            this.gateway = gateway;
            return this.self();
        }

        public T netmask(String netmask) {
            this.netmask = netmask;
            return this.self();
        }

        public T startIP(String startIP) {
            this.startIP = startIP;
            return this.self();
        }

        public T endIP(String endIP) {
            this.endIP = endIP;
            return this.self();
        }

        public T networkId(String networkId) {
            this.networkId = networkId;
            return this.self();
        }

        public VlanIPRange build() {
            return new VlanIPRange(this.id, this.description, this.forVirtualNetwork, this.zoneId, this.vlan, this.account, this.domainId, this.domain, this.podId, this.podName, this.gateway, this.netmask, this.startIP, this.endIP, this.networkId);
        }

        public T fromVlanIPRange(VlanIPRange in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).description(in.getDescription())).forVirtualNetwork(in.isForVirtualNetwork())).zoneId(in.getZoneId())).vlan(in.getVlan())).account(in.getAccount())).domainId(in.getDomainId())).domain(in.getDomain())).podId(in.getPodId())).podName(in.getPodName())).gateway(in.getGateway())).netmask(in.getNetmask())).startIP(in.getStartIP())).endIP(in.getEndIP())).networkId(in.getNetworkId());
        }
    }
}

