/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.inject.Named;
import org.jclouds.cloudstack.domain.AsyncJobError;
import org.jclouds.javax.annotation.Nullable;

public class AsyncJob<S> {
    @Named(value="accountid")
    private final String accountId;
    private final String cmd;
    private final Date created;
    @Named(value="jobid")
    private final String id;
    @Named(value="jobinstanceid")
    private final String instanceId;
    @Named(value="jobinstancetype")
    private final String instanceType;
    @Named(value="jobprocstatus")
    private final int progress;
    @Named(value="jobresult")
    private final S result;
    @Named(value="jobresultcode")
    private final ResultCode resultCode;
    @Named(value="jobresulttype")
    private final String resultType;
    @Named(value="jobstatus")
    private final Status status;
    @Named(value="userid")
    private final String userId;
    private final AsyncJobError error;

    public static <T> Builder<?, T> builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromAsyncJob(this);
    }

    @ConstructorProperties(value={"accountid", "cmd", "created", "jobid", "jobinstanceid", "jobinstancetype", "jobprocstatus", "jobresult", "jobresultcode", "jobresulttype", "jobstatus", "userid", "error"})
    protected AsyncJob(@Nullable String accountId, @Nullable String cmd, @Nullable Date created, String id, @Nullable String instanceId, @Nullable String instanceType, int progress, @Nullable S result, @Nullable ResultCode resultCode, @Nullable String resultType, @Nullable Status status, @Nullable String userId, @Nullable AsyncJobError error) {
        this.accountId = accountId;
        this.cmd = cmd;
        this.created = created;
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.instanceId = instanceId;
        this.instanceType = instanceType;
        this.progress = progress;
        this.result = result;
        this.resultCode = resultCode;
        this.resultType = resultType;
        this.status = status;
        this.userId = userId;
        this.error = error;
    }

    @Nullable
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    public String getCmd() {
        return this.cmd;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    @Nullable
    public String getInstanceType() {
        return this.instanceType;
    }

    public int getProgress() {
        return this.progress;
    }

    @Nullable
    public S getResult() {
        return this.result;
    }

    @Nullable
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public String getResultType() {
        return this.resultType;
    }

    @Nullable
    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public AsyncJobError getError() {
        return this.error;
    }

    public boolean hasFailed() {
        return this.getError() != null || this.getResultCode() == ResultCode.FAIL || this.getStatus() == Status.FAILED;
    }

    public boolean hasSucceed() {
        return this.getError() == null && this.getResultCode() == ResultCode.SUCCESS && this.getStatus() == Status.SUCCEEDED;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accountId, this.cmd, this.created, this.id, this.instanceId, this.instanceType, this.progress, this.result, this.resultCode, this.resultType, this.status, this.userId, this.error});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncJob that = (AsyncJob)AsyncJob.class.cast(obj);
        return Objects.equal((Object)this.accountId, (Object)that.accountId) && Objects.equal((Object)this.cmd, (Object)that.cmd) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.instanceId, (Object)that.instanceId) && Objects.equal((Object)this.instanceType, (Object)that.instanceType) && Objects.equal((Object)this.progress, (Object)that.progress) && Objects.equal(this.result, that.result) && Objects.equal((Object)((Object)this.resultCode), (Object)((Object)that.resultCode)) && Objects.equal((Object)this.resultType, (Object)that.resultType) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)this.userId, (Object)that.userId) && Objects.equal((Object)this.error, (Object)that.error);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("accountId", (Object)this.accountId).add("cmd", (Object)this.cmd).add("created", (Object)this.created).add("id", (Object)this.id).add("instanceId", (Object)this.instanceId).add("instanceType", (Object)this.instanceType).add("progress", this.progress).add("result", this.result).add("resultCode", (Object)this.resultCode).add("resultType", (Object)this.resultType).add("status", (Object)this.status).add("userId", (Object)this.userId).add("error", (Object)this.error);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder<T>
    extends Builder<ConcreteBuilder<T>, T> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder<T> self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T, S>, S> {
        protected String accountId;
        protected String cmd;
        protected Date created;
        protected String id;
        protected String instanceId;
        protected String instanceType;
        protected int progress;
        protected S result;
        protected ResultCode resultCode;
        protected String resultType;
        protected Status status;
        protected String userId;
        protected AsyncJobError error;

        protected abstract T self();

        public T accountId(String accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T cmd(String cmd) {
            this.cmd = cmd;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this.self();
        }

        public T instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this.self();
        }

        public T progress(int progress) {
            this.progress = progress;
            return this.self();
        }

        public T result(S result) {
            this.result = result;
            return this.self();
        }

        public T resultCode(ResultCode resultCode) {
            this.resultCode = resultCode;
            return this.self();
        }

        public T resultType(String resultType) {
            this.resultType = resultType;
            return this.self();
        }

        public T status(Status status) {
            this.status = status;
            return this.self();
        }

        public T userId(String userId) {
            this.userId = userId;
            return this.self();
        }

        public T error(AsyncJobError error) {
            this.error = error;
            return this.self();
        }

        public AsyncJob build() {
            return new AsyncJob<S>(this.accountId, this.cmd, this.created, this.id, this.instanceId, this.instanceType, this.progress, this.result, this.resultCode, this.resultType, this.status, this.userId, this.error);
        }

        public T fromAsyncJob(AsyncJob<S> in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.accountId(in.getAccountId())).cmd(in.getCmd())).created(in.getCreated())).id(in.getId())).instanceId(in.getInstanceId())).instanceType(in.getInstanceType())).progress(in.getProgress())).result(in.getResult())).resultCode(in.getResultCode())).resultType(in.getResultType())).status(in.getStatus())).userId(in.getUserId())).error(in.getError());
        }

        public static Builder<?, Object> fromAsyncJobUntyped(AsyncJob in) {
            return new ConcreteBuilder().fromAsyncJob(in);
        }
    }

    public static enum Status {
        IN_PROGRESS(0),
        SUCCEEDED(1),
        FAILED(2),
        UNKNOWN(-1);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static Status fromValue(String value) {
            try {
                int statusCode = Integer.parseInt(value);
                switch (statusCode) {
                    case 0: {
                        return IN_PROGRESS;
                    }
                    case 1: {
                        return SUCCEEDED;
                    }
                    case 2: {
                        return FAILED;
                    }
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }

    public static enum ResultCode {
        SUCCESS(0),
        FAIL(530),
        UNKNOWN(-1);

        private final int code;

        private ResultCode(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static ResultCode fromValue(String value) {
            try {
                int resultCode = Integer.parseInt(value);
                switch (resultCode) {
                    case 0: {
                        return SUCCESS;
                    }
                    case 530: {
                        return FAIL;
                    }
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }
}

