/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class LoadBalancerRule {
    private final String id;
    private final String account;
    private final Algorithm algorithm;
    private final String description;
    private final String domain;
    @Named(value="domainid")
    private final String domainId;
    private final String name;
    @Named(value="privateport")
    private final int privatePort;
    @Named(value="publicip")
    private final String publicIP;
    @Named(value="publicipid")
    private final String publicIPId;
    @Named(value="publicport")
    private final int publicPort;
    private final State state;
    @Named(value="cidrlist")
    private final Set<String> CIDRs;
    private final String zoneId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromLoadBalancerRule(this);
    }

    @ConstructorProperties(value={"id", "account", "algorithm", "description", "domain", "domainid", "name", "privateport", "publicip", "publicipid", "publicport", "state", "cidrlist", "zoneId"})
    protected LoadBalancerRule(String id, @Nullable String account, @Nullable Algorithm algorithm, @Nullable String description, @Nullable String domain, @Nullable String domainId, @Nullable String name, int privatePort, @Nullable String publicIP, @Nullable String publicIPId, int publicPort, @Nullable State state, @Nullable Set<String> CIDRs, @Nullable String zoneId) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.account = account;
        this.algorithm = algorithm;
        this.description = description;
        this.domain = domain;
        this.domainId = domainId;
        this.name = name;
        this.privatePort = privatePort;
        this.publicIP = publicIP;
        this.publicIPId = publicIPId;
        this.publicPort = publicPort;
        this.state = state;
        this.CIDRs = CIDRs == null ? ImmutableSet.of() : ImmutableSet.copyOf(CIDRs);
        this.zoneId = zoneId;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    @Nullable
    public String getPublicIP() {
        return this.publicIP;
    }

    @Nullable
    public String getPublicIPId() {
        return this.publicIPId;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.algorithm, this.description, this.domain, this.domainId, this.name, this.privatePort, this.publicIP, this.publicIPId, this.publicPort, this.state, this.CIDRs, this.zoneId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerRule that = (LoadBalancerRule)LoadBalancerRule.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)((Object)this.algorithm), (Object)((Object)that.algorithm)) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.privatePort, (Object)that.privatePort) && Objects.equal((Object)this.publicIP, (Object)that.publicIP) && Objects.equal((Object)this.publicIPId, (Object)that.publicIPId) && Objects.equal((Object)this.publicPort, (Object)that.publicPort) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal(this.CIDRs, that.CIDRs) && Objects.equal((Object)this.zoneId, (Object)that.zoneId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("account", (Object)this.account).add("algorithm", (Object)this.algorithm).add("description", (Object)this.description).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("name", (Object)this.name).add("privatePort", this.privatePort).add("publicIP", (Object)this.publicIP).add("publicIPId", (Object)this.publicIPId).add("publicPort", this.publicPort).add("state", (Object)this.state).add("CIDRs", this.CIDRs).add("zoneId", (Object)this.zoneId);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected Algorithm algorithm;
        protected String description;
        protected String domain;
        protected String domainId;
        protected String name;
        protected int privatePort;
        protected String publicIP;
        protected String publicIPId;
        protected int publicPort;
        protected State state;
        protected Set<String> CIDRs = ImmutableSet.of();
        protected String zoneId;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T privatePort(int privatePort) {
            this.privatePort = privatePort;
            return this.self();
        }

        public T publicIP(String publicIP) {
            this.publicIP = publicIP;
            return this.self();
        }

        public T publicIPId(String publicIPId) {
            this.publicIPId = publicIPId;
            return this.self();
        }

        public T publicPort(int publicPort) {
            this.publicPort = publicPort;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T CIDRs(Set<String> CIDRs) {
            this.CIDRs = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(CIDRs, (Object)"CIDRs")));
            return this.self();
        }

        public T CIDRs(String ... in) {
            return this.CIDRs((Set<String>)ImmutableSet.copyOf((Object[])in));
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public LoadBalancerRule build() {
            return new LoadBalancerRule(this.id, this.account, this.algorithm, this.description, this.domain, this.domainId, this.name, this.privatePort, this.publicIP, this.publicIPId, this.publicPort, this.state, this.CIDRs, this.zoneId);
        }

        public T fromLoadBalancerRule(LoadBalancerRule in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).algorithm(in.getAlgorithm())).description(in.getDescription())).domain(in.getDomain())).domainId(in.getDomainId())).name(in.getName())).privatePort(in.getPrivatePort())).publicIP(in.getPublicIP())).publicIPId(in.getPublicIPId())).publicPort(in.getPublicPort())).state(in.getState())).CIDRs(in.getCIDRs())).zoneId(in.getZoneId());
        }
    }

    public static enum Algorithm {
        SOURCE,
        ROUNDROBIN,
        LEASTCONN,
        UNRECOGNIZED;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Algorithm fromValue(String algorithm) {
            try {
                return Algorithm.valueOf(((String)Preconditions.checkNotNull((Object)algorithm, (Object)"algorithm")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum State {
        ADD,
        ACTIVE,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

