/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import org.jclouds.cloudwatch.CloudWatchClient;
import org.jclouds.cloudwatch.domain.ListMetricsResponse;
import org.jclouds.cloudwatch.domain.Metric;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.features.MetricClient;
import org.jclouds.cloudwatch.options.ListMetricsOptions;

public class CloudWatch {
    public static Iterable<Metric> listMetrics(final MetricClient metricClient, final ListMetricsOptions options) {
        return new Iterable<Metric>(){

            @Override
            public Iterator<Metric> iterator() {
                return new AbstractIterator<Metric>(){
                    private ListMetricsOptions lastOptions;
                    private ListMetricsResponse response;
                    private Iterator<Metric> iterator;
                    {
                        this.lastOptions = options;
                        this.response = metricClient.listMetrics(this.lastOptions);
                        this.iterator = this.response.iterator();
                    }

                    protected Metric computeNext() {
                        while (true) {
                            if (this.iterator == null) {
                                this.lastOptions = ListMetricsOptions.builder().namespace(this.lastOptions.getNamespace()).metricName(this.lastOptions.getMetricName()).dimensions(this.lastOptions.getDimensions()).nextToken(this.lastOptions.getNextToken()).build();
                                this.response = metricClient.listMetrics(this.lastOptions);
                                this.iterator = this.response.iterator();
                            }
                            if (this.iterator.hasNext()) {
                                return this.iterator.next();
                            }
                            if (this.response.getNextToken() == null) {
                                return (Metric)this.endOfData();
                            }
                            this.iterator = null;
                        }
                    }
                };
            }
        };
    }

    public static Iterable<Metric> listMetrics(CloudWatchClient cloudWatchClient, String region, ListMetricsOptions options) {
        return CloudWatch.listMetrics(cloudWatchClient.getMetricClientForRegion(region), options);
    }

    public static void putMetricData(CloudWatchClient cloudWatchClient, String region, Iterable<MetricDatum> metrics, String namespace) {
        MetricClient metricClient = cloudWatchClient.getMetricClientForRegion(region);
        for (List slice : Iterables.partition(metrics, (int)10)) {
            metricClient.putMetricData(slice, namespace);
        }
    }
}

