/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.binders;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Date;
import javax.inject.Inject;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.GetMetricStatistics;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Beta
public class GetMetricStatisticsBinder
implements Binder {
    private final DateService dateService;

    @Inject
    protected GetMetricStatisticsBinder(DateService dateService) {
        this.dateService = dateService;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        GetMetricStatistics getRequest = (GetMetricStatistics)GetMetricStatistics.class.cast(Preconditions.checkNotNull((Object)payload, (Object)"GetMetricStatistics must be set!"));
        int dimensionIndex = 1;
        int statisticIndex = 1;
        ImmutableMultimap.Builder formParameters = ImmutableMultimap.builder();
        for (Dimension dimension : getRequest.getDimensions()) {
            formParameters.put((Object)("Dimensions.member." + dimensionIndex + ".Name"), (Object)dimension.getName());
            formParameters.put((Object)("Dimensions.member." + dimensionIndex + ".Value"), (Object)dimension.getValue());
            ++dimensionIndex;
        }
        if (getRequest.getEndTime().isPresent()) {
            formParameters.put((Object)"EndTime", (Object)this.dateService.iso8601SecondsDateFormat((Date)getRequest.getEndTime().get()));
        }
        formParameters.put((Object)"MetricName", (Object)getRequest.getMetricName());
        formParameters.put((Object)"Namespace", (Object)getRequest.getNamespace());
        formParameters.put((Object)"Period", (Object)Integer.toString(getRequest.getPeriod()));
        if (getRequest.getStartTime().isPresent()) {
            formParameters.put((Object)"StartTime", (Object)this.dateService.iso8601SecondsDateFormat((Date)getRequest.getStartTime().get()));
        }
        for (Statistics statistic : getRequest.getStatistics()) {
            formParameters.put((Object)("Statistics.member." + statisticIndex), (Object)statistic.toString());
            ++statisticIndex;
        }
        if (getRequest.getUnit().isPresent()) {
            formParameters.put((Object)"Unit", (Object)((Unit)((Object)getRequest.getUnit().get())).toString());
        }
        return (R)ModifyRequest.putFormParams(request, (Multimap)formParameters.build());
    }
}

