/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.StatisticValues;
import org.jclouds.cloudwatch.domain.Unit;

public class MetricDatum {
    private final Set<Dimension> dimensions;
    private final String metricName;
    private final Optional<StatisticValues> statisticValues;
    private final Optional<Date> timestamp;
    private final Unit unit;
    private final double value;

    protected MetricDatum(Set<Dimension> dimensions, String metricName, StatisticValues statisticValues, Date timestamp, Unit unit, double value) {
        this.dimensions = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(dimensions, (Object)"dimensions")));
        this.metricName = (String)Preconditions.checkNotNull((Object)metricName, (Object)"metricName");
        this.statisticValues = Optional.fromNullable((Object)statisticValues);
        this.timestamp = Optional.fromNullable((Object)timestamp);
        this.unit = (Unit)((Object)Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit"));
        this.value = (Double)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    public Set<Dimension> getDimensions() {
        return this.dimensions;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Optional<StatisticValues> getStatisticValues() {
        return this.statisticValues;
    }

    public Optional<Date> getTimestamp() {
        return this.timestamp;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public double getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDatum that = (MetricDatum)MetricDatum.class.cast(o);
        return Objects.equal(this.dimensions, that.dimensions) && Objects.equal((Object)this.metricName, (Object)that.metricName) && Objects.equal(this.statisticValues, that.statisticValues) && Objects.equal(this.timestamp, that.timestamp) && Objects.equal((Object)((Object)this.unit), (Object)((Object)that.unit)) && Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dimensions, this.metricName, this.statisticValues, this.timestamp, this.unit, this.value});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("dimensions", this.dimensions).add("metricName", (Object)this.metricName).add("statisticValues", this.statisticValues).add("timestamp", this.timestamp).add("unit", (Object)this.unit).add("value", this.value);
    }

    public static class Builder {
        private Set<Dimension> dimensions = Sets.newLinkedHashSet();
        private String metricName;
        private StatisticValues statisticValues;
        private Date timestamp;
        private Unit unit = Unit.NONE;
        private double value;

        public Builder dimensions(Set<Dimension> dimensions) {
            this.dimensions.addAll((Collection)Preconditions.checkNotNull(dimensions, (Object)"dimensions"));
            return this;
        }

        public Builder dimension(Dimension dimension) {
            this.dimensions.add((Dimension)Preconditions.checkNotNull((Object)dimension, (Object)"dimension"));
            return this;
        }

        public Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public Builder statisticValues(StatisticValues statisticValues) {
            this.statisticValues = statisticValues;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder unit(Unit unit) {
            this.unit = unit;
            return this;
        }

        public Builder value(double value) {
            this.value = value;
            return this;
        }

        public MetricDatum build() {
            return new MetricDatum(this.dimensions, this.metricName, this.statisticValues, this.timestamp, this.unit, this.value);
        }
    }
}

