/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.javax.annotation.Nullable;

public class ListMetricsOptions
extends BaseHttpRequestOptions {
    private final Set<Dimension> dimensions;
    private final String metricName;
    private final String namespace;
    private final String nextToken;

    private ListMetricsOptions(@Nullable String namespace, @Nullable String metricName, @Nullable Set<Dimension> dimensions, @Nullable String nextToken) {
        this.dimensions = dimensions;
        this.metricName = metricName;
        this.namespace = namespace;
        this.nextToken = nextToken;
    }

    @Nullable
    public Set<Dimension> getDimensions() {
        return this.dimensions;
    }

    @Nullable
    public String getMetricName() {
        return this.metricName;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public String getNextToken() {
        return this.nextToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<Dimension> dimensions = Sets.newLinkedHashSet();
        private String metricName;
        private String namespace;
        private String nextToken;

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public Builder dimensions(Set<Dimension> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder dimension(Dimension dimension) {
            this.dimensions.add(dimension);
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public ListMetricsOptions build() {
            ListMetricsOptions lmo = new ListMetricsOptions(this.namespace, this.metricName, this.dimensions, this.nextToken);
            int dimensionIndex = 1;
            if (this.namespace != null) {
                lmo.formParameters.put((Object)"Namespace", (Object)this.namespace);
            }
            if (this.metricName != null) {
                lmo.formParameters.put((Object)"MetricName", (Object)this.metricName);
            }
            if (this.dimensions != null) {
                for (Dimension dimension : this.dimensions) {
                    lmo.formParameters.put((Object)("Dimensions.member." + dimensionIndex + ".Name"), (Object)dimension.getName());
                    lmo.formParameters.put((Object)("Dimensions.member." + dimensionIndex + ".Value"), (Object)dimension.getValue());
                    ++dimensionIndex;
                }
            }
            if (this.nextToken != null) {
                lmo.formParameters.put((Object)"NextToken", (Object)this.nextToken);
            }
            return lmo;
        }
    }
}

