/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.deltacloud.domain.DeltacloudCollection;
import org.jclouds.deltacloud.domain.Feature;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DeltacloudCollectionHandler
extends ParseSax.HandlerWithResult<DeltacloudCollection> {
    private URI href;
    private String rel;
    private Set<Feature> features = Sets.newLinkedHashSet();
    private DeltacloudCollection realm;

    public DeltacloudCollection getResult() {
        return this.realm;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (qName.equalsIgnoreCase("link")) {
            this.href = URI.create((String)attributes.get("href"));
            this.rel = (String)attributes.get("rel");
        } else if (qName.equalsIgnoreCase("feature")) {
            this.features.add(new Feature((String)attributes.get("name")));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("link")) {
            this.realm = new DeltacloudCollection(this.href, this.rel, this.features);
            this.href = null;
            this.rel = null;
            this.features = Sets.newLinkedHashSet();
        }
    }
}

