/**
 * Licensed to jclouds, Inc. (jclouds) under one or more
 * contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  jclouds licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jclouds.ec2.functions;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

import javax.inject.Singleton;

import org.jclouds.crypto.CryptoStreams;

import com.google.common.base.Function;

/**
 * Binds base64 encodes the byte [] input
 * 
 * @author Adrian Cole
 */
@Singleton
public class ConvertUnencodedBytesToBase64EncodedString implements Function<Object, String> {

   @Override
   public String apply(Object from) {
      checkArgument(checkNotNull(from, "input") instanceof byte[], "this binder is only valid for byte []!");

      byte[] unencodedData = (byte[]) from;
      checkArgument(checkNotNull(unencodedData, "unencodedData").length <= 16 * 1024,
               "userData cannot be larger than 16kb");
      return CryptoStreams.base64(unencodedData);
   }
}
