/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.config;

import com.google.common.base.Function;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.Map;
import org.jclouds.elasticstack.ElasticStackAsyncClient;
import org.jclouds.elasticstack.ElasticStackClient;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveData;
import org.jclouds.elasticstack.domain.DriveMetrics;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerMetrics;
import org.jclouds.elasticstack.functions.CreateDriveRequestToMap;
import org.jclouds.elasticstack.functions.DriveDataToMap;
import org.jclouds.elasticstack.functions.MapToDevices;
import org.jclouds.elasticstack.functions.MapToDriveMetrics;
import org.jclouds.elasticstack.functions.MapToNICs;
import org.jclouds.elasticstack.functions.MapToServerMetrics;
import org.jclouds.elasticstack.functions.ServerToMap;
import org.jclouds.elasticstack.handlers.ElasticStackErrorHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@RequiresHttp
@ConfiguresRestClient
public class ElasticStackRestClientModule
extends RestClientModule<ElasticStackClient, ElasticStackAsyncClient> {
    public ElasticStackRestClientModule() {
        super(ElasticStackClient.class, ElasticStackAsyncClient.class);
    }

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<Function<Drive, Map<String, String>>>(){}).to(CreateDriveRequestToMap.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<DriveData, Map<String, String>>>(){}).to(DriveDataToMap.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, List<NIC>>>(){}).to(MapToNICs.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends Device>>>(){}).to(MapToDevices.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends DriveMetrics>>>(){}).to(MapToDriveMetrics.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, ServerMetrics>>(){}).to(MapToServerMetrics.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Device, String>>(){}).to(MapToDevices.DeviceToId.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Server, Map<String, String>>>(){}).to(ServerToMap.class);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ElasticStackErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ElasticStackErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ElasticStackErrorHandler.class);
    }

    protected void bindRetryHandlers() {
    }
}

