/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class ListOfKeyValuesDelimitedByBlankLinesToListOfMaps
implements Function<String, List<Map<String, String>>> {
    public List<Map<String, String>> apply(String from) {
        ArrayList maps = Lists.newArrayList();
        for (String listOfKeyValues : Splitter.on((String)"\n\n").split((CharSequence)from)) {
            if ("".equals(listOfKeyValues)) continue;
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (String keyValueLine : Splitter.on((char)'\n').split((CharSequence)listOfKeyValues)) {
                int firstIndex;
                if ("".equals(keyValueLine) || (firstIndex = keyValueLine.indexOf(32)) == -1) continue;
                String key = keyValueLine.substring(0, firstIndex);
                String value = keyValueLine.substring(firstIndex + 1).replace("\\n", "\n");
                map.put(key, value);
            }
            if (map.size() == 0) continue;
            maps.add(map);
        }
        return maps;
    }
}

