/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.util.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.inject.Provider;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.filesystem.strategy.FilesystemStorageStrategy;

public class FileSystemBlobUtilsImpl
implements BlobUtils {
    protected final FilesystemStorageStrategy storageStrategy;
    protected final Provider<BlobBuilder> blobBuilders;

    @Inject
    public FileSystemBlobUtilsImpl(FilesystemStorageStrategy storageStrategy, Provider<BlobBuilder> blobBuilders) {
        this.storageStrategy = (FilesystemStorageStrategy)Preconditions.checkNotNull((Object)storageStrategy, (Object)"Filesystem Storage Strategy");
        this.blobBuilders = (Provider)Preconditions.checkNotNull(blobBuilders, (Object)"Filesystem  blobBuilders");
    }

    public BlobBuilder blobBuilder() {
        return (BlobBuilder)this.blobBuilders.get();
    }

    public boolean directoryExists(String containerName, String directory) {
        return this.storageStrategy.directoryExists(containerName, directory);
    }

    public void createDirectory(String containerName, String directory) {
        this.storageStrategy.createDirectory(containerName, directory);
    }

    public long countBlobs(String container, ListContainerOptions options) {
        return this.storageStrategy.countBlobs(container, options);
    }

    public void clearContainer(String container, ListContainerOptions options) {
        this.storageStrategy.clearContainer(container, options);
    }

    public void deleteDirectory(String container, String directory) {
        this.storageStrategy.deleteDirectory(container, directory);
    }
}

