/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Endpoint(value=Identity.class)
@SkipEncoding(value={47, 61})
public interface TenantAsyncClient {
    @GET
    @SelectJson(value="tenants")
    @Consumes(value={"application/json"})
    @Path(value="/tenants")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Tenant>> list();

    @GET
    @SelectJson(value="tenant")
    @Consumes(value={"application/json"})
    @Path(value="/tenants/{tenantId}")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Tenant> get(@PathParam(value="tenantId") String var1);

    @GET
    @SelectJson(value="tenant")
    @Consumes(value={"application/json"})
    @Path(value="/tenants")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Tenant> getByName(@QueryParam(value="name") String var1);
}

