/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.v2_0.AuthenticationClient;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.PasswordCredentials;
import org.jclouds.openstack.keystone.v2_0.functions.internal.BaseAuthenticator;

@CredentialType(value="passwordCredentials")
@Singleton
public class AuthenticatePasswordCredentials
extends BaseAuthenticator<PasswordCredentials> {
    protected final AuthenticationClient client;

    @Inject
    public AuthenticatePasswordCredentials(AuthenticationClient client) {
        this.client = client;
    }

    @Override
    protected Access authenticateWithTenantNameOrNull(String tenantId, PasswordCredentials apiAccessKeyCredentials) {
        return this.client.authenticateWithTenantNameAndCredentials(tenantId, apiAccessKeyCredentials);
    }

    @Override
    protected Access authenticateWithTenantId(String tenantId, PasswordCredentials apiAccessKeyCredentials) {
        return this.client.authenticateWithTenantIdAndCredentials(tenantId, apiAccessKeyCredentials);
    }

    @Override
    public PasswordCredentials createCredentials(String identity, String credential) {
        return PasswordCredentials.createWithUsernameAndPassword(identity, credential);
    }

    public String toString() {
        return "authenticatePasswordCredentials()";
    }
}

