/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions.internal;

import com.google.common.base.Function;
import javax.annotation.Resource;
import org.jclouds.domain.Credentials;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.v2_0.domain.Access;

public abstract class BaseAuthenticator<C>
implements Function<Credentials, Access> {
    @Resource
    protected Logger logger = Logger.NULL;

    public Access apply(Credentials input) {
        String tenantId = null;
        String usernameOrAccessKey = input.identity;
        if (input.identity.indexOf(58) == -1) {
            this.logger.debug("Identity %s does not match format tenantName:accessKey", new Object[]{input.identity});
        } else {
            tenantId = input.identity.substring(0, input.identity.indexOf(58));
            usernameOrAccessKey = input.identity.substring(input.identity.indexOf(58) + 1);
        }
        String passwordOrSecretKey = input.credential;
        C creds = this.createCredentials(usernameOrAccessKey, passwordOrSecretKey);
        Access access = tenantId != null && tenantId.matches("^[0-9]+$") ? this.authenticateWithTenantId(tenantId, creds) : this.authenticateWithTenantNameOrNull(tenantId, creds);
        return access;
    }

    public abstract C createCredentials(String var1, String var2);

    protected abstract Access authenticateWithTenantId(String var1, C var2);

    protected abstract Access authenticateWithTenantNameOrNull(String var1, C var2);
}

