/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.RetryOnTimeOutExceptionFunction;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.location.suppliers.RegionIdsSupplier;
import org.jclouds.location.suppliers.ZoneIdToURISupplier;
import org.jclouds.location.suppliers.ZoneIdsSupplier;
import org.jclouds.location.suppliers.derived.RegionIdsFromRegionIdToURIKeySet;
import org.jclouds.location.suppliers.derived.ZoneIdsFromZoneIdToURIKeySet;
import org.jclouds.openstack.keystone.v2_0.AuthenticationAsyncClient;
import org.jclouds.openstack.keystone.v2_0.AuthenticationClient;
import org.jclouds.openstack.keystone.v2_0.config.Authentication;
import org.jclouds.openstack.keystone.v2_0.config.CredentialTypes;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.functions.AuthenticateApiAccessKeyCredentials;
import org.jclouds.openstack.keystone.v2_0.functions.AuthenticatePasswordCredentials;
import org.jclouds.openstack.keystone.v2_0.handlers.RetryOnRenew;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURIFromAccessForTypeAndVersion;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURISupplier;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToURIFromAccessForTypeAndVersion;
import org.jclouds.openstack.keystone.v2_0.suppliers.ZoneIdToURIFromAccessForTypeAndVersion;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.BinderUtils;

public class KeystoneAuthenticationModule
extends AbstractModule {
    private final Module locationModule;

    public KeystoneAuthenticationModule() {
        this((Module)new RegionModule());
    }

    protected KeystoneAuthenticationModule(Module locationModule) {
        this.locationModule = locationModule;
    }

    public static Module forRegions() {
        return new KeystoneAuthenticationModuleForRegions();
    }

    public static Module forZones() {
        return new KeystoneAuthenticationModuleForZones();
    }

    protected void configure() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
        this.bindAuthenticationClient();
        this.install(this.locationModule);
    }

    protected void bindAuthenticationClient() {
        BinderUtils.bindClientAndAsyncClient((Binder)this.binder(), AuthenticationClient.class, AuthenticationAsyncClient.class);
    }

    @Provides
    @Singleton
    @Authentication
    protected Supplier<String> provideAuthenticationTokenCache(final Supplier<Access> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return new Supplier<String>(){

            public String get() {
                return ((Access)supplier.get()).getToken().getId();
            }
        };
    }

    @Provides
    @Singleton
    protected Map<String, Function<Credentials, Access>> authenticationMethods(Injector i) {
        ImmutableSet.Builder fns = ImmutableSet.builder();
        fns.add(i.getInstance(AuthenticatePasswordCredentials.class));
        fns.add(i.getInstance(AuthenticateApiAccessKeyCredentials.class));
        return CredentialTypes.indexByCredentialType(fns.build());
    }

    @Provides
    @Singleton
    protected Function<Credentials, Access> authenticationMethodForCredentialType(@Named(value="jclouds.keystone.credential-type") String credentialType, Map<String, Function<Credentials, Access>> authenticationMethods) {
        Preconditions.checkArgument((boolean)authenticationMethods.containsKey(credentialType), (String)"credential type %s not in supported list: %s", (Object[])new Object[]{credentialType, authenticationMethods.keySet()});
        return new RetryOnTimeOutExceptionFunction(authenticationMethods.get(credentialType));
    }

    @Provides
    @Singleton
    public LoadingCache<Credentials, Access> provideAccessCache(Function<Credentials, Access> getAccess) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build(CacheLoader.from(getAccess));
    }

    @Provides
    @Singleton
    protected Supplier<Access> provideAccessSupplier(final LoadingCache<Credentials, Access> cache, final @Provider Credentials creds) {
        return new Supplier<Access>(){

            public Access get() {
                try {
                    return (Access)cache.get((Object)creds);
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate((Throwable)e.getCause());
                }
            }
        };
    }

    public static class KeystoneAuthenticationModuleForZones
    extends KeystoneAuthenticationModule {
        public KeystoneAuthenticationModuleForZones() {
            super((Module)new ZoneModule());
        }
    }

    public static class ZoneModule
    extends AbstractModule {
        protected void configure() {
            this.install(new FactoryModuleBuilder().implement(ZoneIdToURISupplier.class, ZoneIdToURIFromAccessForTypeAndVersion.class).build(ZoneIdToURISupplier.Factory.class));
            this.bind(ZoneIdsSupplier.class).to(ZoneIdsFromZoneIdToURIKeySet.class);
        }

        @Provides
        @Singleton
        protected ZoneIdToURISupplier provideZoneIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, ZoneIdToURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }
    }

    public static class RegionModule
    extends AbstractModule {
        protected void configure() {
            this.install(new FactoryModuleBuilder().implement(RegionIdToURISupplier.class, RegionIdToURIFromAccessForTypeAndVersion.class).build(RegionIdToURISupplier.Factory.class));
            this.install(new FactoryModuleBuilder().implement(RegionIdToAdminURISupplier.class, RegionIdToAdminURIFromAccessForTypeAndVersion.class).build(RegionIdToAdminURISupplier.Factory.class));
            this.bind(RegionIdsSupplier.class).to(RegionIdsFromRegionIdToURIKeySet.class);
        }

        @Provides
        @Singleton
        protected RegionIdToURISupplier provideRegionIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }

        @Provides
        @Singleton
        protected RegionIdToAdminURISupplier provideRegionIdToAdminURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToAdminURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }
    }

    public static class KeystoneAuthenticationModuleForRegions
    extends KeystoneAuthenticationModule {
        public KeystoneAuthenticationModuleForRegions() {
            super((Module)new RegionModule());
        }
    }
}

