/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.MediaType;
import org.jclouds.openstack.v2_0.domain.Resource;

public class ApiMetadata
extends Resource {
    @Nullable
    private String status;
    @Nullable
    private Date updated;
    @SerializedName(value="media-types")
    private Set<MediaType> mediaTypes = Sets.newLinkedHashSet();

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromApiMetadata(this);
    }

    protected ApiMetadata() {
    }

    protected ApiMetadata(Builder<?> builder) {
        super(builder);
        this.status = (String)Preconditions.checkNotNull((Object)((Builder)builder).status, (Object)"status");
        this.updated = (Date)Preconditions.checkNotNull((Object)((Builder)builder).updated, (Object)"updated");
        this.mediaTypes = ImmutableSet.copyOf((Collection)((Builder)builder).mediaTypes);
    }

    public String getStatus() {
        return this.status;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Set<MediaType> getMediaTypes() {
        return Collections.unmodifiableSet(this.mediaTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.status, this.updated, this.mediaTypes});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiMetadata that = (ApiMetadata)ApiMetadata.class.cast(obj);
        return super.equals(that) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal((Object)this.updated, (Object)that.updated) && Objects.equal(this.mediaTypes, that.mediaTypes);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("status", (Object)this.status).add("updated", (Object)this.updated).add("mediaTypes", this.mediaTypes);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        private String status;
        private Date updated;
        private Set<MediaType> mediaTypes = Sets.newLinkedHashSet();

        public T status(String status) {
            this.status = status;
            return (T)((Builder)this.self());
        }

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Builder)this.self());
        }

        public T mediaTypes(Set<MediaType> mediaTypes) {
            this.mediaTypes = mediaTypes;
            return (T)((Builder)this.self());
        }

        @Override
        public ApiMetadata build() {
            return new ApiMetadata(this);
        }

        public T fromApiMetadata(ApiMetadata in) {
            return ((Builder)((Builder)((Builder)super.fromResource(in)).status(in.getStatus())).updated(in.getUpdated())).mediaTypes(in.getMediaTypes());
        }
    }
}

