/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;

@CredentialType(value="passwordCredentials")
public class PasswordCredentials {
    protected final String username;
    protected final String password;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return PasswordCredentials.builder().fromPasswordCredentials(this);
    }

    public static PasswordCredentials createWithUsernameAndPassword(String username, String password) {
        return PasswordCredentials.builder().password(password).username(username).build();
    }

    protected PasswordCredentials(String username, String password) {
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
        this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PasswordCredentials) {
            PasswordCredentials other = (PasswordCredentials)PasswordCredentials.class.cast(object);
            return Objects.equal((Object)this.username, (Object)other.username) && Objects.equal((Object)this.password, (Object)other.password);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.username, this.password});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("username", (Object)this.username).add("password", (Object)this.password).toString();
    }

    public static class Builder {
        protected String username;
        protected String password;

        protected Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public PasswordCredentials build() {
            return new PasswordCredentials(this.username, this.password);
        }

        public Builder fromPasswordCredentials(PasswordCredentials from) {
            return this.username(from.getUsername()).password(from.getPassword());
        }
    }
}

