/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions;

import com.google.common.base.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.v2_0.AuthenticationClient;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.ApiAccessKeyCredentials;
import org.jclouds.openstack.keystone.v2_0.functions.internal.BaseAuthenticator;

@CredentialType(value="apiAccessKeyCredentials")
@Singleton
public class AuthenticateApiAccessKeyCredentials
extends BaseAuthenticator<ApiAccessKeyCredentials> {
    protected final AuthenticationClient client;

    @Inject
    public AuthenticateApiAccessKeyCredentials(AuthenticationClient client) {
        this.client = client;
    }

    @Override
    protected Access authenticateWithTenantName(Optional<String> tenantName, ApiAccessKeyCredentials apiAccessKeyCredentials) {
        return this.client.authenticateWithTenantNameAndCredentials((String)tenantName.orNull(), apiAccessKeyCredentials);
    }

    @Override
    protected Access authenticateWithTenantId(Optional<String> tenantId, ApiAccessKeyCredentials apiAccessKeyCredentials) {
        return this.client.authenticateWithTenantIdAndCredentials((String)tenantId.orNull(), apiAccessKeyCredentials);
    }

    @Override
    public ApiAccessKeyCredentials createCredentials(String identity, String credential) {
        return ApiAccessKeyCredentials.createWithAccessKeyAndSecretKey(identity, credential);
    }

    public String toString() {
        return "authenticateApiAccessKeyCredentials()";
    }
}

