/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.KeystoneClient;
import org.jclouds.openstack.keystone.v2_0.domain.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestClientExpectTest;
import org.jclouds.openstack.keystone.v2_0.parse.ParseRackspaceApiMetadataTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="KeystoneClientExpectTest")
public class KeystoneClientExpectTest
extends BaseKeystoneRestClientExpectTest<KeystoneClient> {
    public void testGetApiMetaData() {
        KeystoneClient client = (KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, HttpRequest.builder().method("GET").endpoint(URI.create(this.endpoint + "/v2.0/")).headers((Multimap)ImmutableMultimap.of((Object)"Accept", (Object)"application/json")).build(), HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/raxVersion.json", "application/json")).build());
        ApiMetadata metadata = client.getApiMetadata();
        Assert.assertEquals((Object)metadata, (Object)new ParseRackspaceApiMetadataTest().expected());
    }

    public void testGetApiMetaDataFailNotFound() {
        KeystoneClient client = (KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/").headers((Multimap)ImmutableMultimap.of((Object)"Accept", (Object)"application/json")).build(), this.standardResponseBuilder(404).build());
        Assert.assertNull((Object)client.getApiMetadata());
    }
}

