/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.KeystoneClient;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.features.ServiceClient;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestClientExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="ServiceClientExpectTest")
public class ServiceClientExpectTest
extends BaseKeystoneRestClientExpectTest<KeystoneClient> {
    public void testListTenants() {
        ServiceClient client = ((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tenants").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/tenant_list.json", "application/json")).build())).getServiceClient();
        Set tenants = client.listTenants();
        Assert.assertNotNull((Object)tenants);
        Assert.assertFalse((boolean)tenants.isEmpty());
        ImmutableSet expected = ImmutableSet.of((Object)Tenant.builder().name("demo").id("05d1dc7af71646deba64cfc17b81bec0").build(), (Object)Tenant.builder().name("admin").id("7aa2e17ec29f44d193c48feaba0852cc").build());
        Assert.assertEquals((Set)tenants, (Set)expected);
    }

    public void testListTenantsFailNotFound() {
        ServiceClient client = ((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tenants").build(), this.standardResponseBuilder(404).build())).getServiceClient();
        Assert.assertTrue((boolean)client.listTenants().isEmpty());
    }
}

