/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.KeystoneClient;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.features.TenantClient;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestClientExpectTest;
import org.jclouds.rest.AuthorizationException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="TenantClientExpectTest")
public class TenantClientExpectTest
extends BaseKeystoneRestClientExpectTest<KeystoneClient> {
    public TenantClientExpectTest() {
        this.endpoint = "https://csnode.jclouds.org:35357";
    }

    public void testListTenants() {
        TenantClient client = (TenantClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tenants").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/tenant_list.json", "application/json")).build())).getTenantClient().get();
        Set tenants = client.list();
        Assert.assertNotNull((Object)tenants);
        Assert.assertFalse((boolean)tenants.isEmpty());
        ImmutableSet expected = ImmutableSet.of((Object)Tenant.builder().name("demo").id("05d1dc7af71646deba64cfc17b81bec0").build(), (Object)Tenant.builder().name("admin").id("7aa2e17ec29f44d193c48feaba0852cc").build());
        Assert.assertEquals((Set)tenants, (Set)expected);
    }

    public void testListTenantsATT() {
        TenantClient client = (TenantClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tenants").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/tenant_list_att.json", "application/json")).build())).getTenantClient().get();
        Set tenants = client.list();
        Assert.assertNotNull((Object)tenants);
        Assert.assertFalse((boolean)tenants.isEmpty());
        ImmutableSet expected = ImmutableSet.of((Object)Tenant.builder().name("this-is-a-test").id("14").description("None").build());
        Assert.assertEquals((Set)tenants, (Set)expected);
    }

    public void testListTenantsFailNotFound() {
        TenantClient client = (TenantClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tenants").build(), this.standardResponseBuilder(404).build())).getTenantClient().get();
        Assert.assertTrue((boolean)client.list().isEmpty());
    }

    public void testGetTenant() {
        TenantClient client = (TenantClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tenants/013ba41150a14830bec85ffe93353bcc").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/tenant_details.json", "application/json")).build())).getTenantClient().get();
        Tenant tenant = client.get("013ba41150a14830bec85ffe93353bcc");
        Assert.assertNotNull((Object)tenant);
        Assert.assertEquals((Object)tenant, (Object)Tenant.builder().id("013ba41150a14830bec85ffe93353bcc").name("admin").build());
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testListTenantsFailNotAuthorized() {
        TenantClient client = (TenantClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tenants/013ba41150a14830bec85ffe93353bcc").build(), this.standardResponseBuilder(401).build())).getTenantClient().get();
        client.get("013ba41150a14830bec85ffe93353bcc");
    }

    public void testGetTenantByName() {
        TenantClient client = (TenantClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tenants?name=admin").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/tenant_details.json", "application/json")).build())).getTenantClient().get();
        Tenant tenant = client.getByName("admin");
        Assert.assertNotNull((Object)tenant);
        Assert.assertEquals((Object)tenant, (Object)Tenant.builder().id("013ba41150a14830bec85ffe93353bcc").name("admin").build());
    }

    public void testGetTenantByNameFailNotFound() {
        TenantClient client = (TenantClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tenants?name=admin").build(), this.standardResponseBuilder(404).build())).getTenantClient().get();
        Assert.assertNull((Object)client.getByName("admin"));
    }
}

