/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.KeystoneClient;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.features.TenantClient;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneClientLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="TenantClientLiveTest")
public class TenantClientLiveTest
extends BaseKeystoneClientLiveTest {
    public void testTenants() {
        TenantClient client = (TenantClient)((KeystoneClient)this.keystoneContext.getApi()).getTenantClient().get();
        Set result = client.list();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        for (Tenant tenant : result) {
            Assert.assertNotNull((Object)tenant.getId());
            Tenant aTenant = client.get(tenant.getId());
            Assert.assertNotNull((Object)aTenant, (String)("get returned null for tenant: " + tenant));
            Assert.assertEquals((Object)aTenant, (Object)tenant);
        }
    }

    public void testTenantsByName() {
        TenantClient client = (TenantClient)((KeystoneClient)this.keystoneContext.getApi()).getTenantClient().get();
        for (Tenant tenant : client.list()) {
            Tenant aTenant = client.getByName(tenant.getName());
            Assert.assertNotNull((Object)aTenant, (String)("get returned null for tenant: " + tenant));
            Assert.assertEquals((Object)aTenant, (Object)tenant);
        }
    }
}

