/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpResponseException;
import org.jclouds.openstack.keystone.v2_0.KeystoneClient;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.features.TokenClient;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestClientExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="TokenClientExpectTest")
public class TokenClientExpectTest
extends BaseKeystoneRestClientExpectTest<KeystoneClient> {
    private DateService dateService = new SimpleDateFormatDateService();

    public TokenClientExpectTest() {
        this.endpoint = "https://csnode.jclouds.org:35357";
    }

    public void testGetToken() {
        TokenClient client = (TokenClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tokens/sometokenorother").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/token_details.json", "application/json")).build())).getTokenClient().get();
        Token token = client.get("sometokenorother");
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)token, (Object)Token.builder().id("167eccdc790946969ced473732e8109b").expires(this.dateService.iso8601SecondsDateParse("2012-04-28T12:42:50Z")).tenant(Tenant.builder().id("4cea93f5464b4f1c921fb3e0461d72b5").name("demo").build()).build());
    }

    public void testGetTokenFailNotFound() {
        TokenClient client = (TokenClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tokens/sometokenorother").build(), this.standardResponseBuilder(404).build())).getTokenClient().get();
        Assert.assertNull((Object)client.get("sometokenorother"));
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testGetTokenFail500() {
        TokenClient client = (TokenClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tokens/sometokenorother").build(), this.standardResponseBuilder(500).build())).getTokenClient().get();
        client.get("sometokenorother");
    }

    public void testGetUserOfToken() {
        TokenClient client = (TokenClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tokens/sometokenorother").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/token_details.json", "application/json")).build())).getTokenClient().get();
        User user = client.getUserOfToken("sometokenorother");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user, (Object)User.builder().id("2b9b606181634ae9ac86fd95a8bc2cde").name("admin").roles((Set)ImmutableSet.of((Object)Role.builder().id("79cada5c02814b57a52e0eed4dd388cb").name("admin").build())).build());
    }

    public void testGetUserOfTokenFailNotFound() {
        TokenClient client = (TokenClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tokens/sometokenorother").build(), this.standardResponseBuilder(404).build())).getTokenClient().get();
        Assert.assertNull((Object)client.getUserOfToken("sometokenorother"));
    }

    public void testCheckTokenIsValid() {
        TokenClient client = (TokenClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tokens/sometokenorother").method("HEAD").headers((Multimap)ImmutableMultimap.of((Object)"X-Auth-Token", (Object)this.authToken)).build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/token_details.json", "application/json")).build())).getTokenClient().get();
        Assert.assertTrue((boolean)client.isValid("sometokenorother"));
    }

    public void testCheckTokenIsValidFailNotValid() {
        TokenClient client = (TokenClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tokens/sometokenorother").method("HEAD").headers((Multimap)ImmutableMultimap.of((Object)"X-Auth-Token", (Object)this.authToken)).build(), this.standardResponseBuilder(404).build())).getTokenClient().get();
        Assert.assertFalse((boolean)client.isValid("sometokenorother"));
    }

    @Test
    public void testGetEndpointsForToken() {
        TokenClient client = (TokenClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tokens/XXXXXX/endpoints").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/user_endpoints.json", "application/json")).build())).getTokenClient().get();
        Set endpoints = client.listEndpointsForToken("XXXXXX");
        Assert.assertEquals((Set)endpoints, (Set)ImmutableSet.of((Object)Endpoint.builder().publicURL(URI.create("https://csnode.jclouds.org/v2.0/")).adminURL(URI.create("https://csnode.jclouds.org:35357/v2.0/")).region("region-a.geo-1").versionId("2.0").build()));
    }

    @Test
    public void testGetEndpointsForTokenFailNotFound() {
        TokenClient client = (TokenClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/tokens/XXXXXX/endpoints").build(), this.standardResponseBuilder(404).build())).getTokenClient().get();
        Assert.assertTrue((boolean)client.listEndpointsForToken("XXXXXX").isEmpty());
    }
}

