/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneClient;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.features.TokenClient;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneClientLiveTest;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="TokenClientLiveTest", singleThreaded=true)
public class TokenClientLiveTest
extends BaseKeystoneClientLiveTest {
    protected String token;

    @BeforeMethod
    public void grabToken() {
        AuthenticateRequest ar = (AuthenticateRequest)this.keystoneContext.getUtils().getInjector().getInstance(AuthenticateRequest.class);
        HttpRequest test = ar.filter(HttpRequest.builder().method("GET").endpoint(URI.create(this.endpoint)).build());
        this.token = (String)Iterables.getOnlyElement((Iterable)test.getHeaders().get((Object)"X-Auth-Token"));
    }

    public void testToken() {
        TokenClient client = (TokenClient)((KeystoneClient)this.keystoneContext.getApi()).getTokenClient().get();
        AssertJUnit.assertTrue((boolean)client.isValid(this.token));
        Token result = client.get(this.token);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result.getId(), (String)this.token);
        Assert.assertNotNull((Object)result.getTenant());
        User user = client.getUserOfToken(this.token);
        Assert.assertNotNull((Object)user);
        Assert.assertNotNull((Object)user.getId());
        Assert.assertNotNull((Object)user.getName());
    }

    public void testInvalidToken() {
        TokenClient client = (TokenClient)((KeystoneClient)this.keystoneContext.getApi()).getTokenClient().get();
        Assert.assertFalse((boolean)client.isValid("thisisnotarealtoken!"));
        Assert.assertNull((Object)client.get("thisisnotarealtoken!"));
    }

    public void testTokenEndpoints() {
        TokenClient client = (TokenClient)((KeystoneClient)this.keystoneContext.getApi()).getTokenClient().get();
        Set endpoints = client.listEndpointsForToken(this.token);
        Assert.assertNotNull((Object)endpoints);
        Assert.assertFalse((boolean)endpoints.isEmpty());
    }

    public void testInvalidTokenEndpoints() {
        TokenClient client = (TokenClient)((KeystoneClient)this.keystoneContext.getApi()).getTokenClient().get();
        AssertJUnit.assertTrue((boolean)client.listEndpointsForToken("thisisnotarealtoken!").isEmpty());
    }
}

