/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpResponseException;
import org.jclouds.openstack.keystone.v2_0.KeystoneClient;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.features.UserClient;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestClientExpectTest;
import org.jclouds.rest.AuthorizationException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="UserClientExpectTest")
public class UserClientExpectTest
extends BaseKeystoneRestClientExpectTest<KeystoneClient> {
    public UserClientExpectTest() {
        this.endpoint = "https://csnode.jclouds.org:35357";
    }

    public void testListUsers() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/user_list.json", "application/json")).build())).getUserClient().get();
        Set users = client.list();
        Assert.assertNotNull((Object)users);
        Assert.assertFalse((boolean)users.isEmpty());
        ImmutableSet expected = ImmutableSet.of((Object)User.builder().name("nova").id("e021dfd758eb44a89f1c57c8ef3be8e2").build(), (Object)User.builder().name("glance").id("3f6c1c9ba993495ead7d2eb2192e284f").build(), (Object)User.builder().name("demo").id("667b2e1420604df8b67cd8ea57d4ee64").build(), (Object)User.builder().name("admin").id("2b9b606181634ae9ac86fd95a8bc2cde").build());
        Assert.assertEquals((Set)users, (Set)expected);
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testListUsersFailNotAuth() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users").build(), this.standardResponseBuilder(401).build())).getUserClient().get();
        client.list();
    }

    public void testGetUser() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users/e021dfd758eb44a89f1c57c8ef3be8e2").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/user_details.json", "application/json")).build())).getUserClient().get();
        User user = client.get("e021dfd758eb44a89f1c57c8ef3be8e2");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user, (Object)User.builder().name("nova").id("e021dfd758eb44a89f1c57c8ef3be8e2").build());
    }

    public void testGetUserFailNotFound() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users/f021dfd758eb44a89f1c57c8ef3be8e2").build(), this.standardResponseBuilder(404).build())).getUserClient().get();
        Assert.assertNull((Object)client.get("f021dfd758eb44a89f1c57c8ef3be8e2"));
    }

    public void testGetUserByName() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users?name=nova").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/user_details.json", "application/json")).build())).getUserClient().get();
        User user = client.getByName("nova");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user, (Object)User.builder().name("nova").id("e021dfd758eb44a89f1c57c8ef3be8e2").build());
    }

    public void testGetUserByNameFailNotFound() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users?name=fred").build(), this.standardResponseBuilder(404).build())).getUserClient().get();
        Assert.assertNull((Object)client.getByName("fred"));
    }

    public void testListRolesOfUser() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users/3f6c1c9ba993495ead7d2eb2192e284f/roles").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/user_role_list.json", "application/json")).build())).getUserClient().get();
        Set roles = client.listRolesOfUser("3f6c1c9ba993495ead7d2eb2192e284f");
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((boolean)roles.isEmpty());
        Assert.assertEquals((Set)roles, (Set)ImmutableSet.of((Object)Role.builder().id("79cada5c02814b57a52e0eed4dd388cb").name("admin").build()));
    }

    public void testListRolesOfUserFailNotFound() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users/4f6c1c9ba993495ead7d2eb2192e284f/roles").build(), this.standardResponseBuilder(404).build())).getUserClient().get();
        Assert.assertTrue((boolean)client.listRolesOfUser("4f6c1c9ba993495ead7d2eb2192e284f").isEmpty());
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testListRolesOfUserFailNotImplemented() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users/5f6c1c9ba993495ead7d2eb2192e284f/roles").build(), this.standardResponseBuilder(501).build())).getUserClient().get();
        Assert.assertTrue((boolean)client.listRolesOfUser("5f6c1c9ba993495ead7d2eb2192e284f").isEmpty());
    }

    public void testListRolesOfUserInTenant() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users/3f6c1c9ba993495ead7d2eb2192e284f/roles").build(), this.standardResponseBuilder(200).payload(this.payloadFromResourceWithContentType("/user_tenant_role_list.json", "application/json")).build())).getUserClient().get();
        Set roles = client.listRolesOfUser("3f6c1c9ba993495ead7d2eb2192e284f");
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((boolean)roles.isEmpty());
        Assert.assertEquals((Set)roles, (Set)ImmutableSet.of((Object)Role.builder().id("31c451195aac49b386039341e2c92a16").name("KeystoneServiceAdmin").build(), (Object)Role.builder().id("79cada5c02814b57a52e0eed4dd388cb").name("admin").build(), (Object)Role.builder().id("6ea17ddd37a6447794cb0e164d4db894").name("KeystoneAdmin").build()));
    }

    public void testListRolesOfUserInTenantFailNotFound() {
        UserClient client = (UserClient)((KeystoneClient)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPassword, this.responseWithKeystoneAccess, this.standardRequestBuilder(this.endpoint + "/v2.0/users/3f6c1c9ba993495ead7d2eb2192e284f/roles").build(), this.standardResponseBuilder(404).build())).getUserClient().get();
        Assert.assertTrue((boolean)client.listRolesOfUser("3f6c1c9ba993495ead7d2eb2192e284f").isEmpty());
    }
}

