/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.KeystoneClient;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.features.TenantClient;
import org.jclouds.openstack.keystone.v2_0.features.UserClient;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneClientLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="UserClientLiveTest", singleThreaded=true)
public class UserClientLiveTest
extends BaseKeystoneClientLiveTest {
    public void testUsers() {
        UserClient client = (UserClient)((KeystoneClient)this.keystoneContext.getApi()).getUserClient().get();
        Set users = client.list();
        Assert.assertNotNull((Object)users);
        Assert.assertFalse((boolean)users.isEmpty());
        for (User user : users) {
            User aUser = client.get(user.getId());
            Assert.assertEquals((Object)aUser, (Object)user);
        }
    }

    public void testUserRolesOnTenant() {
        UserClient client = (UserClient)((KeystoneClient)this.keystoneContext.getApi()).getUserClient().get();
        Set users = client.list();
        Set tenants = ((TenantClient)((KeystoneClient)this.keystoneContext.getApi()).getTenantClient().get()).list();
        for (User user : users) {
            for (Tenant tenant : tenants) {
                Set roles = client.listRolesOfUserOnTenant(user.getId(), tenant.getId());
                for (Role role : roles) {
                    Assert.assertNotNull((Object)role.getId());
                }
            }
        }
    }

    public void testListRolesOfUser() {
        UserClient client = (UserClient)((KeystoneClient)this.keystoneContext.getApi()).getUserClient().get();
        for (User user : client.list()) {
            Set roles = client.listRolesOfUser(user.getId());
            for (Role role : roles) {
                Assert.assertNotNull((Object)role.getId());
            }
        }
    }

    public void testUsersByName() {
        UserClient client = (UserClient)((KeystoneClient)this.keystoneContext.getApi()).getUserClient().get();
        for (User user : client.list()) {
            User aUser = client.getByName(user.getName());
            Assert.assertEquals((Object)aUser, (Object)user);
        }
    }
}

