/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.internal;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.KeystoneApiMetadata;
import org.jclouds.openstack.keystone.v2_0.internal.KeystoneFixture;
import org.jclouds.rest.internal.BaseRestClientExpectTest;

public class BaseKeystoneRestClientExpectTest<S>
extends BaseRestClientExpectTest<S> {
    protected HttpRequest keystoneAuthWithUsernameAndPassword;
    protected HttpRequest keystoneAuthWithAccessKeyAndSecretKey;
    protected String authToken;
    protected HttpResponse responseWithKeystoneAccess;
    protected String endpoint = "http://localhost:5000";

    public BaseKeystoneRestClientExpectTest() {
        this.provider = "openstack-keystone";
        this.keystoneAuthWithUsernameAndPassword = KeystoneFixture.INSTANCE.initialAuthWithUsernameAndPasswordAndTenantName(this.identity, this.credential);
        this.keystoneAuthWithAccessKeyAndSecretKey = KeystoneFixture.INSTANCE.initialAuthWithAccessKeyAndSecretKeyAndTenantName(this.identity, this.credential);
        this.authToken = KeystoneFixture.INSTANCE.getAuthToken();
        this.responseWithKeystoneAccess = KeystoneFixture.INSTANCE.responseWithAccess();
        this.identity = KeystoneFixture.INSTANCE.getTenantName() + ":" + this.identity;
    }

    protected HttpRequest.Builder standardRequestBuilder(String endpoint) {
        return HttpRequest.builder().method("GET").headers((Multimap)ImmutableMultimap.of((Object)"Accept", (Object)"application/json", (Object)"X-Auth-Token", (Object)this.authToken)).endpoint(URI.create(endpoint));
    }

    protected HttpResponse.Builder standardResponseBuilder(int status) {
        return HttpResponse.builder().statusCode(status);
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.put("jclouds.keystone.service-type", "identity");
        return props;
    }

    protected BaseRestClientExpectTest.HttpRequestComparisonType compareHttpRequestAsType(HttpRequest input) {
        return Objects.equal((Object)"HEAD", (Object)input.getMethod()) ? BaseRestClientExpectTest.HttpRequestComparisonType.DEFAULT : BaseRestClientExpectTest.HttpRequestComparisonType.JSON;
    }

    protected ApiMetadata createApiMetadata() {
        return new KeystoneApiMetadata();
    }
}

