/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.rest.internal.BaseRestClientExpectTest;
import org.jclouds.util.Strings2;

public enum KeystoneFixture {
    INSTANCE;


    public String getTenantId() {
        return "12346637803162";
    }

    public String getTenantName() {
        return "adrian@jclouds.org";
    }

    public HttpRequest initialAuthWithUsernameAndPassword(String username, String password) {
        return HttpRequest.builder().method("POST").endpoint(URI.create("http://localhost:5000/v2.0/tokens")).headers((Multimap)ImmutableMultimap.of((Object)"Accept", (Object)"application/json")).payload(BaseRestClientExpectTest.payloadFromStringWithContentType((String)String.format("{\"auth\":{\"passwordCredentials\":{\"username\":\"%s\",\"password\":\"%s\"}}}", username, password), (String)"application/json")).build();
    }

    public HttpRequest initialAuthWithUsernameAndPasswordAndTenantName(String username, String password) {
        return HttpRequest.builder().method("POST").endpoint(URI.create("http://localhost:5000/v2.0/tokens")).headers((Multimap)ImmutableMultimap.of((Object)"Accept", (Object)"application/json")).payload(BaseRestClientExpectTest.payloadFromStringWithContentType((String)String.format("{\"auth\":{\"passwordCredentials\":{\"username\":\"%s\",\"password\":\"%s\"},\"tenantName\":\"%s\"}}", username, password, this.getTenantName()), (String)"application/json")).build();
    }

    public HttpRequest initialAuthWithAccessKeyAndSecretKeyAndTenantName(String accessKey, String secretKey) {
        return HttpRequest.builder().method("POST").endpoint(URI.create("http://localhost:5000/v2.0/tokens")).headers((Multimap)ImmutableMultimap.of((Object)"Accept", (Object)"application/json")).payload(BaseRestClientExpectTest.payloadFromStringWithContentType((String)String.format("{\"auth\":{\"apiAccessKeyCredentials\":{\"accessKey\":\"%s\",\"secretKey\":\"%s\"},\"tenantName\":\"%s\"}}", accessKey, secretKey, this.getTenantName()), (String)"application/json")).build();
    }

    public HttpRequest initialAuthWithAccessKeyAndSecretKeyAndTenantId(String accessKey, String secretKey) {
        return HttpRequest.builder().method("POST").endpoint(URI.create("http://localhost:5000/v2.0/tokens")).headers((Multimap)ImmutableMultimap.of((Object)"Accept", (Object)"application/json")).payload(BaseRestClientExpectTest.payloadFromStringWithContentType((String)String.format("{\"auth\":{\"apiAccessKeyCredentials\":{\"accessKey\":\"%s\",\"secretKey\":\"%s\"},\"tenantId\":\"%s\"}}", accessKey, secretKey, this.getTenantId()), (String)"application/json")).build();
    }

    public String getAuthToken() {
        return "Auth_4f173437e4b013bee56d1007";
    }

    public HttpResponse responseWithAccess() {
        return HttpResponse.builder().statusCode(200).message("HTTP/1.1 200").payload(this.payloadFromResourceWithContentType("/keystoneAuthResponse.json", "application/json")).build();
    }

    public Payload payloadFromResourceWithContentType(String resource, String contentType) {
        try {
            return BaseRestClientExpectTest.payloadFromStringWithContentType((String)Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resource)), (String)contentType);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

