/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Singleton;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.parse.ParseAccessTest;
import org.jclouds.openstack.keystone.v2_0.parse.ParseRackspaceAccessTest;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToURIFromAccessForTypeAndVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RegionIdToURIFromAccessForTypeAndVersionTest")
public class RegionIdToURIFromAccessForTypeAndVersionTest {
    private final RegionIdToURISupplier.Factory factory = (RegionIdToURISupplier.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith(Provider.class).to("openstack-keystone");
            this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Provider.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("https://identity")));
            this.install(new FactoryModuleBuilder().implement(RegionIdToURISupplier.class, RegionIdToURIFromAccessForTypeAndVersion.class).build(RegionIdToURISupplier.Factory.class));
        }

        @Provides
        @Singleton
        public Supplier<Access> provide() {
            return Suppliers.ofInstance((Object)new ParseAccessTest().expected());
        }
    }}).getInstance(RegionIdToURISupplier.Factory.class);
    private final RegionIdToURISupplier.Factory raxFactory = (RegionIdToURISupplier.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith(Provider.class).to("rackspace");
            this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Provider.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("https://identity")));
            this.install(new FactoryModuleBuilder().implement(RegionIdToURISupplier.class, RegionIdToURIFromAccessForTypeAndVersion.class).build(RegionIdToURISupplier.Factory.class));
        }

        @Provides
        @Singleton
        public Supplier<Access> provide() {
            return Suppliers.ofInstance((Object)new ParseRackspaceAccessTest().expected());
        }
    }}).getInstance(RegionIdToURISupplier.Factory.class);

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testRegionUnmatches() {
        Maps.transformValues((Map)((Map)this.factory.createForApiTypeAndVersion("compute", "1.0").get()), (Function)Suppliers.supplierFunction());
    }

    public void testRegionMatches() {
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.factory.createForApiTypeAndVersion("compute", "1.1").get()), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"az-1.region-a.geo-1", (Object)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456"), (Object)"az-2.region-a.geo-1", (Object)URI.create("https://az-2.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456"), (Object)"az-3.region-a.geo-1", (Object)URI.create("https://az-3.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456")));
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testWhenNotInList() {
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.raxFactory.createForApiTypeAndVersion("goo", "1.0").get()), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"rackspace", (Object)URI.create("https://servers.api.rackspacecloud.com/v1.0/40806637803162")));
    }

    public void testProviderWhenNoRegions() {
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.raxFactory.createForApiTypeAndVersion("compute", "1.0").get()), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"rackspace", (Object)URI.create("https://servers.api.rackspacecloud.com/v1.0/40806637803162")));
    }

    public void testOkWithNoVersions() {
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.raxFactory.createForApiTypeAndVersion("rax:database", null).get()), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"DFW", (Object)URI.create("https://dfw.databases.api.rackspacecloud.com/v1.0/40806637803162"), (Object)"ORD", (Object)URI.create("https://ord.databases.api.rackspacecloud.com/v1.0/40806637803162")));
    }
}

