/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class Link {
    @Named(value="rel")
    private final Relation relation;
    private final String type;
    private final URI href;

    public static Link create(Relation relation, URI href) {
        return new Link(relation, null, href);
    }

    public static Link create(Relation relation, String type, URI href) {
        return new Link(relation, type, href);
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromLink(this);
    }

    @ConstructorProperties(value={"rel", "type", "href"})
    protected Link(Relation relation, @Nullable String type, URI href) {
        this.relation = (Relation)((Object)Preconditions.checkNotNull((Object)((Object)relation), (Object)"relation"));
        this.type = type;
        this.href = (URI)Preconditions.checkNotNull((Object)href, (Object)"href");
    }

    public Relation getRelation() {
        return this.relation;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public URI getHref() {
        return this.href;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.relation, this.type, this.href});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Link that = (Link)Link.class.cast(obj);
        return Objects.equal((Object)((Object)this.relation), (Object)((Object)that.relation)) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.href, (Object)that.href);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("relation", (Object)this.relation).add("type", (Object)this.type).add("href", (Object)this.href);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Relation relation;
        protected String type;
        protected URI href;

        protected abstract T self();

        public T relation(Relation relation) {
            this.relation = relation;
            return this.self();
        }

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public T href(URI href) {
            this.href = href;
            return this.self();
        }

        public Link build() {
            return new Link(this.relation, this.type, this.href);
        }

        public T fromLink(Link in) {
            return ((Builder)((Builder)this.relation(in.getRelation())).type(in.getType())).href(in.getHref());
        }
    }

    public static enum Relation {
        SELF,
        BOOKMARK,
        DESCRIBEDBY,
        ALTERNATE,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static Relation fromValue(String v) {
            try {
                return Relation.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

