/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.http.utils.Queries;
import org.jclouds.openstack.v2_0.domain.Link;

@Beta
public class PaginatedCollection<T>
extends IterableWithMarker<T> {
    private Iterable<T> resources;
    private Iterable<Link> links;

    protected PaginatedCollection(Iterable<T> resources, Iterable<Link> links) {
        this.resources = resources != null ? resources : ImmutableSet.of();
        this.links = links != null ? links : ImmutableSet.of();
    }

    public Iterator<T> iterator() {
        return this.resources.iterator();
    }

    public Iterable<Link> getLinks() {
        return this.links;
    }

    public Optional<Object> nextMarker() {
        return (Optional)FluentIterable.from(this.getLinks()).filter((Predicate)new Predicate<Link>(){

            public boolean apply(Link link) {
                return Link.Relation.NEXT == link.getRelation();
            }
        }).transform((Function)new Function<Link, Optional<Object>>(){

            public Optional<Object> apply(Link link) {
                Collection markers = ((Multimap)Queries.queryParser().apply((Object)link.getHref().getRawQuery())).get((Object)"marker");
                return Optional.fromNullable(markers == null ? null : (String)Iterables.get((Iterable)markers, (int)0));
            }
        }).first().or((Object)Optional.absent());
    }
}

