/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v1_1.NovaClient;
import org.jclouds.openstack.nova.v1_1.domain.KeyPair;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v1_1.extensions.KeyPairClient;

@Singleton
public class CreateUniqueKeyPair
implements Function<ZoneAndName, KeyPair> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaClient novaClient;
    protected final Supplier<String> randomSuffix;

    @Inject
    public CreateUniqueKeyPair(NovaClient novaClient, Supplier<String> randomSuffix) {
        this.novaClient = (NovaClient)Preconditions.checkNotNull((Object)novaClient, (Object)"novaClient");
        this.randomSuffix = randomSuffix;
    }

    public KeyPair apply(ZoneAndName zoneAndName) {
        String zoneId = ((ZoneAndName)Preconditions.checkNotNull((Object)zoneAndName, (Object)"zoneAndName")).getZone();
        String prefix = zoneAndName.getName();
        Optional<KeyPairClient> client = this.novaClient.getKeyPairExtensionForZone(zoneId);
        Preconditions.checkArgument((boolean)client.isPresent(), (String)"Key pairs are required, but the extension is not available in zone %s!", (Object[])new Object[]{zoneId});
        this.logger.debug(">> creating keyPair zone(%s) prefix(%s)", new Object[]{zoneId, prefix});
        KeyPair keyPair = null;
        while (keyPair == null) {
            try {
                keyPair = ((KeyPairClient)client.get()).createKeyPair(this.getNextName(prefix));
            }
            catch (IllegalStateException e) {}
        }
        this.logger.debug("<< created keyPair(%s)", new Object[]{keyPair.getName()});
        return keyPair;
    }

    private String getNextName(String prefix) {
        return String.format("%s_%s", prefix, this.randomSuffix.get());
    }
}

