/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.io.Payload;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.util.Preconditions2;

public class NovaTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected boolean autoAssignFloatingIp = false;
    protected Set<String> securityGroupNames = ImmutableSet.of();
    protected boolean generateKeyPair = false;
    protected String keyPairName;
    public static final NovaTemplateOptions NONE = new NovaTemplateOptions();

    public NovaTemplateOptions clone() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof NovaTemplateOptions) {
            NovaTemplateOptions eTo = (NovaTemplateOptions)NovaTemplateOptions.class.cast(to);
            eTo.autoAssignFloatingIp(this.shouldAutoAssignFloatingIp());
            eTo.securityGroupNames(this.getSecurityGroupNames());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NovaTemplateOptions that = (NovaTemplateOptions)NovaTemplateOptions.class.cast(o);
        return super.equals((Object)that) && Objects.equal((Object)this.autoAssignFloatingIp, (Object)that.autoAssignFloatingIp) && Objects.equal(this.securityGroupNames, that.securityGroupNames) && Objects.equal((Object)this.generateKeyPair, (Object)that.generateKeyPair) && Objects.equal((Object)this.keyPairName, (Object)that.keyPairName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.autoAssignFloatingIp, this.securityGroupNames, this.generateKeyPair, this.keyPairName});
    }

    public Objects.ToStringHelper string() {
        return super.string().add("autoAssignFloatingIp", this.autoAssignFloatingIp).add("securityGroupNames", this.securityGroupNames).add("generateKeyPair", this.generateKeyPair).add("keyPairName", (Object)this.keyPairName);
    }

    public NovaTemplateOptions autoAssignFloatingIp(boolean enable) {
        this.autoAssignFloatingIp = enable;
        return this;
    }

    public NovaTemplateOptions generateKeyPair(boolean enable) {
        this.generateKeyPair = enable;
        return this;
    }

    public NovaTemplateOptions keyPairName(String keyPairName) {
        this.keyPairName = keyPairName;
        return this;
    }

    public NovaTemplateOptions securityGroupNames(String ... securityGroupNames) {
        return this.securityGroupNames((Iterable<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)securityGroupNames, (Object)"securityGroupNames"))));
    }

    public NovaTemplateOptions securityGroupNames(Iterable<String> securityGroupNames) {
        for (String groupName : (Iterable)Preconditions.checkNotNull(securityGroupNames, (Object)"securityGroupNames")) {
            Preconditions2.checkNotEmpty((String)groupName, (String)"all security groups must be non-empty");
        }
        this.securityGroupNames = ImmutableSet.copyOf(securityGroupNames);
        return this;
    }

    public boolean shouldAutoAssignFloatingIp() {
        return this.autoAssignFloatingIp;
    }

    public String getKeyPairName() {
        return this.keyPairName;
    }

    public boolean shouldGenerateKeyPair() {
        return this.generateKeyPair;
    }

    public Set<String> getSecurityGroupNames() {
        return this.securityGroupNames;
    }

    public NovaTemplateOptions blockOnPort(int port, int seconds) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public NovaTemplateOptions inboundPorts(int ... ports) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public NovaTemplateOptions authorizePublicKey(String publicKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public NovaTemplateOptions installPrivateKey(String privateKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Deprecated
    public NovaTemplateOptions runScript(Payload script) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.runScript(script));
    }

    public NovaTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public NovaTemplateOptions dontAuthorizePublicKey() {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public NovaTemplateOptions nameTask(String name) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.nameTask(name));
    }

    public NovaTemplateOptions runAsRoot(boolean runAsRoot) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public NovaTemplateOptions runScript(Statement script) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.runScript(script));
    }

    @Deprecated
    public NovaTemplateOptions overrideCredentialsWith(Credentials overridingCredentials) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideCredentialsWith(overridingCredentials));
    }

    @Deprecated
    public NovaTemplateOptions overrideLoginUserWith(String loginUser) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginUserWith(loginUser));
    }

    @Deprecated
    public NovaTemplateOptions overrideLoginCredentialWith(String loginCredential) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginCredentialWith(loginCredential));
    }

    public NovaTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public NovaTemplateOptions overrideLoginPassword(String password) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public NovaTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public NovaTemplateOptions overrideLoginUser(String loginUser) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public NovaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public NovaTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public NovaTemplateOptions userMetadata(String key, String value) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public static class Builder {
        public static NovaTemplateOptions autoAssignFloatingIp(boolean enable) {
            return new NovaTemplateOptions().autoAssignFloatingIp(enable);
        }

        public static NovaTemplateOptions generateKeyPair(boolean enable) {
            return new NovaTemplateOptions().generateKeyPair(enable);
        }

        public static NovaTemplateOptions keyPairName(String keyPairName) {
            return new NovaTemplateOptions().keyPairName(keyPairName);
        }

        public static NovaTemplateOptions securityGroupNames(String ... groupNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static NovaTemplateOptions securityGroupNames(Iterable<String> groupNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static NovaTemplateOptions inboundPorts(int ... ports) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static NovaTemplateOptions blockOnPort(int port, int seconds) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static NovaTemplateOptions installPrivateKey(String rsaKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static NovaTemplateOptions authorizePublicKey(String rsaKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static NovaTemplateOptions userMetadata(Map<String, String> userMetadata) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static NovaTemplateOptions overrideLoginUser(String user) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static NovaTemplateOptions overrideLoginPassword(String password) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static NovaTemplateOptions overrideLoginPrivateKey(String privateKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static NovaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static NovaTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }
    }
}

