/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.openstack.domain.Link;
import org.jclouds.openstack.domain.Resource;

public class Image
extends Resource {
    private final Date updated;
    private final Date created;
    @SerializedName(value="tenant_id")
    private final String tenantId;
    @SerializedName(value="user_id")
    private final String userId;
    private final Status status;
    private final int progress;
    private final int minDisk;
    private final int minRam;
    private final Resource server;
    private final Map<String, String> metadata;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Image.builder().fromImage(this);
    }

    protected Image(String id, String name, Set<Link> links, Date updated, Date created, String tenantId, String userId, Status status, int progress, int minDisk, int minRam, Resource server, Map<String, String> metadata) {
        super(id, name, links);
        this.updated = updated;
        this.created = created;
        this.tenantId = tenantId;
        this.userId = userId;
        this.status = status;
        this.progress = progress;
        this.minDisk = minDisk;
        this.minRam = minRam;
        this.server = server;
        this.metadata = ImmutableMap.copyOf(metadata);
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMinDisk() {
        return this.minDisk;
    }

    public int getMinRam() {
        return this.minRam;
    }

    public Resource getServer() {
        return this.server;
    }

    public Map<String, String> getMetadata() {
        return ImmutableMap.copyOf((Map)Maps.filterValues(this.metadata, (Predicate)Predicates.notNull()));
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("name", (Object)this.name).add("links", (Object)this.links).add("updated", (Object)this.updated).add("created", (Object)this.created).add("tenantId", (Object)this.tenantId).add("userId", (Object)this.userId).add("status", (Object)this.status).add("progress", this.progress).add("minDisk", this.minDisk).add("minRam", this.minRam).add("server", (Object)this.server).add("metadata", this.metadata).toString();
    }

    public static class Builder
    extends Resource.Builder {
        private Date updated;
        private Date created;
        private String tenantId;
        private String userId;
        private Status status;
        private int progress;
        private int minDisk;
        private int minRam;
        private Resource server;
        private Map<String, String> metadata = Maps.newLinkedHashMap();

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder progress(int progress) {
            this.progress = progress;
            return this;
        }

        public Builder minDisk(int minDisk) {
            this.minDisk = minDisk;
            return this;
        }

        public Builder minRam(int minRam) {
            this.minRam = minRam;
            return this;
        }

        public Builder server(Resource server) {
            this.server = server;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Image build() {
            return new Image(this.id, this.name, this.links, this.updated, this.created, this.tenantId, this.userId, this.status, this.progress, this.minDisk, this.minRam, this.server, this.metadata);
        }

        public Builder fromImage(Image in) {
            return this.fromResource(in).status(in.getStatus()).updated(in.getUpdated()).created(in.getCreated()).progress(in.getProgress()).server(in.getServer()).metadata(in.getMetadata());
        }

        public Builder id(String id) {
            return (Builder)((Object)Builder.class.cast(super.id(id)));
        }

        public Builder name(String name) {
            return (Builder)((Object)Builder.class.cast(super.name(name)));
        }

        public Builder links(Set<Link> links) {
            return (Builder)((Object)Builder.class.cast(super.links(links)));
        }

        public Builder fromResource(Resource in) {
            return (Builder)((Object)Builder.class.cast(super.fromResource(in)));
        }
    }

    public static enum Status {
        UNRECOGNIZED,
        UNKNOWN,
        ACTIVE,
        SAVING,
        ERROR,
        DELETED;


        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            try {
                return Status.valueOf(v);
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

