/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.domain.Link;
import org.jclouds.openstack.domain.Resource;
import org.jclouds.openstack.nova.v1_1.domain.Address;
import org.jclouds.util.InetAddresses2;
import org.jclouds.util.Multimaps2;

public class Server
extends Resource {
    protected final String uuid;
    @SerializedName(value="tenant_id")
    protected final String tenantId;
    @SerializedName(value="user_id")
    protected final String userId;
    protected final Date updated;
    protected final Date created;
    protected final String hostId;
    protected final String accessIPv4;
    protected final String accessIPv6;
    protected final Status status;
    protected final Resource image;
    protected final Resource flavor;
    protected final String adminPass;
    @SerializedName(value="key_name")
    protected final String keyName;
    @SerializedName(value="config_drive")
    protected final String configDrive;
    protected final Map<Address.Type, Set<Address>> addresses;
    protected final Map<String, String> metadata;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Server.builder().fromServer(this);
    }

    protected Server(String id, String name, Set<Link> links, @Nullable String uuid, String tenantId, String userId, Date updated, Date created, @Nullable String hostId, @Nullable String accessIPv4, @Nullable String accessIPv6, Status status, @Nullable String configDrive, Resource image, Resource flavor, String adminPass, @Nullable String keyName, Multimap<Address.Type, Address> addresses, Map<String, String> metadata) {
        super(id, name, links);
        this.uuid = uuid;
        this.tenantId = (String)Preconditions.checkNotNull((Object)tenantId, (Object)"tenantId");
        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"userId");
        this.updated = (Date)Preconditions.checkNotNull((Object)updated, (Object)"updated");
        this.created = (Date)Preconditions.checkNotNull((Object)created, (Object)"created");
        this.hostId = hostId;
        this.accessIPv4 = accessIPv4;
        this.accessIPv6 = accessIPv6;
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.configDrive = configDrive;
        this.image = (Resource)Preconditions.checkNotNull((Object)image, (Object)"image");
        this.flavor = (Resource)Preconditions.checkNotNull((Object)flavor, (Object)"flavor");
        this.metadata = Maps.newHashMap(metadata);
        this.addresses = Multimaps2.toOldSchool((Multimap)ImmutableMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull(addresses, (Object)"addresses"))));
        this.adminPass = adminPass;
        this.keyName = keyName;
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getHostId() {
        return Strings.emptyToNull((String)this.hostId);
    }

    @Nullable
    public String getAccessIPv4() {
        return Strings.emptyToNull((String)this.accessIPv4);
    }

    @Nullable
    public String getAccessIPv6() {
        return Strings.emptyToNull((String)this.accessIPv6);
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public String getConfigDrive() {
        return Strings.emptyToNull((String)this.configDrive);
    }

    public Resource getImage() {
        return this.image;
    }

    public Resource getFlavor() {
        return this.flavor;
    }

    public Map<String, String> getMetadata() {
        return ImmutableMap.copyOf((Map)Maps.filterValues(this.metadata, (Predicate)Predicates.notNull()));
    }

    public Set<Address> getPrivateAddresses() {
        Collection privateAddresses = this.getAddresses().get((Object)Address.Type.PRIVATE);
        if (privateAddresses == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)privateAddresses);
    }

    public Set<Address> getInternetAddresses() {
        Collection internetAddrs = this.getAddresses().get((Object)Address.Type.INTERNET);
        if (internetAddrs == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)internetAddrs);
    }

    public Set<Address> getPublicAddresses() {
        Collection publicAddrs = this.getAddresses().get((Object)Address.Type.PUBLIC);
        if (publicAddrs == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)publicAddrs);
    }

    public Multimap<Address.Type, Address> getAddresses() {
        Set<Address> privateAddresses = this.addresses.get((Object)Address.Type.PRIVATE);
        if (privateAddresses != null && privateAddresses.size() > 1) {
            return this.hackNeededForFloatingIpsFixedInEssex(privateAddresses);
        }
        return Multimaps2.fromOldSchool(this.addresses);
    }

    private Multimap<Address.Type, Address> hackNeededForFloatingIpsFixedInEssex(Set<Address> privateAddresses) {
        Set<Address> publicAddresses = this.addresses.get((Object)Address.Type.PUBLIC);
        ImmutableSetMultimap.Builder returnMapBuilder = new ImmutableSetMultimap.Builder();
        if (publicAddresses != null) {
            returnMapBuilder.putAll((Object)Address.Type.PUBLIC, publicAddresses);
        }
        returnMapBuilder.putAll((Object)Address.Type.PRIVATE, Iterables.filter(privateAddresses, (Predicate)IsPrivateAddress.INSTANCE));
        returnMapBuilder.putAll((Object)Address.Type.PUBLIC, Iterables.filter(privateAddresses, (Predicate)Predicates.not((Predicate)IsPrivateAddress.INSTANCE)));
        return returnMapBuilder.build();
    }

    @Nullable
    public String getAdminPass() {
        return this.adminPass;
    }

    @Nullable
    public String getKeyName() {
        return this.keyName;
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.id).add("uuid", (Object)this.uuid).add("name", (Object)this.name).add("tenantId", (Object)this.tenantId).add("userId", (Object)this.userId).add("hostId", (Object)this.getHostId()).add("updated", (Object)this.updated).add("created", (Object)this.created).add("accessIPv4", (Object)this.getAccessIPv4()).add("accessIPv6", (Object)this.getAccessIPv6()).add("status", (Object)this.status).add("configDrive", (Object)this.getConfigDrive()).add("image", (Object)this.image).add("flavor", (Object)this.flavor).add("metadata", this.metadata).add("links", (Object)this.links).add("addresses", this.getAddresses()).add("adminPass", (Object)this.adminPass);
    }

    private static enum IsPrivateAddress implements Predicate<Address>
    {
        INSTANCE;


        public boolean apply(Address in) {
            return InetAddresses2.IsPrivateIPAddress.INSTANCE.apply(in.getAddr());
        }
    }

    public static class Builder
    extends Resource.Builder {
        private String uuid;
        private String tenantId;
        private String userId;
        private Date updated;
        private Date created;
        private String hostId;
        private String accessIPv4;
        private String accessIPv6;
        private Status status;
        private String configDrive;
        private Resource image;
        private Resource flavor;
        private Map<String, String> metadata = Maps.newHashMap();
        private Multimap<Address.Type, Address> addresses = LinkedHashMultimap.create();
        private String adminPass;
        private String keyName;

        public Builder uuid(@Nullable String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder hostId(@Nullable String hostId) {
            this.hostId = hostId;
            return this;
        }

        public Builder accessIPv4(@Nullable String accessIPv4) {
            this.accessIPv4 = accessIPv4;
            return this;
        }

        public Builder accessIPv6(@Nullable String accessIPv6) {
            this.accessIPv6 = accessIPv6;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder configDrive(@Nullable String configDrive) {
            this.configDrive = configDrive;
            return this;
        }

        public Builder image(Resource image) {
            this.image = image;
            return this;
        }

        public Builder flavor(Resource flavor) {
            this.flavor = flavor;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf(metadata);
            return this;
        }

        public Builder addresses(Multimap<Address.Type, Address> addresses) {
            this.addresses = ImmutableMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull(addresses, (Object)"addresses")));
            return this;
        }

        public Builder privateAddresses(Address ... privateAddresses) {
            return this.privateAddresses((Set<Address>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)privateAddresses, (Object)"privateAddresses"))));
        }

        public Builder privateAddresses(Set<Address> privateAddresses) {
            this.addresses.replaceValues((Object)Address.Type.PRIVATE, (Iterable)ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(privateAddresses, (Object)"privateAddresses"))));
            return this;
        }

        public Builder internetAddresses(Address ... internetAddresses) {
            return this.internetAddresses((Set<Address>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)internetAddresses, (Object)"internetAddresses"))));
        }

        public Builder internetAddresses(Set<Address> internetAddresses) {
            this.addresses.replaceValues((Object)Address.Type.INTERNET, (Iterable)ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(internetAddresses, (Object)"internetAddresses"))));
            return this;
        }

        public Builder publicAddresses(Address ... publicAddresses) {
            return this.publicAddresses((Set<Address>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)publicAddresses, (Object)"publicAddresses"))));
        }

        public Builder publicAddresses(Set<Address> publicAddresses) {
            this.addresses.replaceValues((Object)Address.Type.PUBLIC, (Iterable)ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(publicAddresses, (Object)"publicAddresses"))));
            return this;
        }

        public Builder adminPass(String adminPass) {
            this.adminPass = adminPass;
            return this;
        }

        public Builder keyName(@Nullable String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Server build() {
            return new Server(this.id, this.name, this.links, this.uuid, this.tenantId, this.userId, this.updated, this.created, this.hostId, this.accessIPv4, this.accessIPv6, this.status, this.configDrive, this.image, this.flavor, this.adminPass, this.keyName, this.addresses, this.metadata);
        }

        public Builder fromServer(Server in) {
            return this.fromResource(in).uuid(in.getUuid()).tenantId(in.getTenantId()).userId(in.getUserId()).updated(in.getUpdated()).created(in.getCreated()).hostId(in.getHostId()).accessIPv4(in.getAccessIPv4()).accessIPv6(in.getAccessIPv6()).status(in.getStatus()).configDrive(in.getConfigDrive()).image(in.getImage()).flavor(in.getFlavor()).adminPass(in.getAdminPass()).keyName(in.getKeyName()).addresses(in.getAddresses()).metadata(in.getMetadata());
        }

        public Builder id(String id) {
            return (Builder)((Object)Builder.class.cast(super.id(id)));
        }

        public Builder name(String name) {
            return (Builder)((Object)Builder.class.cast(super.name(name)));
        }

        public Builder links(Set<Link> links) {
            return (Builder)((Object)Builder.class.cast(super.links(links)));
        }

        public Builder links(Link ... links) {
            return (Builder)((Object)Builder.class.cast(super.links(links)));
        }

        public Builder fromResource(Resource in) {
            return (Builder)((Object)Builder.class.cast(super.fromResource(in)));
        }
    }

    public static enum Status {
        ACTIVE(NodeState.RUNNING),
        BUILD(NodeState.PENDING),
        REBUILD(NodeState.PENDING),
        SUSPENDED(NodeState.SUSPENDED),
        RESIZE(NodeState.PENDING),
        VERIFY_RESIZE(NodeState.PENDING),
        REVERT_RESIZE(NodeState.PENDING),
        PASSWORD(NodeState.PENDING),
        REBOOT(NodeState.PENDING),
        HARD_REBOOT(NodeState.PENDING),
        DELETED(NodeState.TERMINATED),
        UNKNOWN(NodeState.UNRECOGNIZED),
        ERROR(NodeState.ERROR),
        UNRECOGNIZED(NodeState.UNRECOGNIZED);

        private final NodeState nodeState;

        private Status(NodeState nodeState) {
            this.nodeState = nodeState;
        }

        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            try {
                return Status.valueOf(v.replaceAll("\\(.*", ""));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        public NodeState getNodeState() {
            return this.nodeState;
        }
    }
}

