/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.functions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.internal.ClassMethodArgsAndReturnVal;
import org.jclouds.openstack.nova.v1_1.predicates.ExtensionPredicates;
import org.jclouds.openstack.services.Extension;
import org.jclouds.rest.functions.ImplicitOptionalConverter;

@Singleton
public class PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet
implements ImplicitOptionalConverter {
    private final LoadingCache<String, Set<org.jclouds.openstack.nova.v1_1.domain.Extension>> extensions;

    @Inject
    public PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet(LoadingCache<String, Set<org.jclouds.openstack.nova.v1_1.domain.Extension>> extensions) {
        this.extensions = (LoadingCache)Preconditions.checkNotNull(extensions, (Object)"extensions");
    }

    public Optional<Object> apply(ClassMethodArgsAndReturnVal input) {
        Optional ext = Optional.fromNullable((Object)input.getClazz().getAnnotation(Extension.class));
        if (ext.isPresent()) {
            Preconditions.checkState((input.getArgs() != null && input.getArgs().length == 1 ? 1 : 0) != 0, (String)"expecting an arg %s", (Object[])new Object[]{input});
            URI namespace = URI.create(((Extension)ext.get()).namespace());
            if (Iterables.any((Iterable)((Iterable)this.extensions.getUnchecked((Object)Preconditions.checkNotNull((Object)input.getArgs()[0], (String)"arg[0] in %s", (Object[])new Object[]{input}).toString())), ExtensionPredicates.namespaceEquals(namespace))) {
                return Optional.of((Object)input.getReturnVal());
            }
        }
        return Optional.absent();
    }

    public String toString() {
        return "presentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet()";
    }
}

