/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.openstack.nova.v1_1.domain.KeyPair;

public class KeyPairPredicates {
    public static Predicate<KeyPair> nameStartsWith(final String prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"name must be defined");
        return new Predicate<KeyPair>(){

            public boolean apply(KeyPair ext) {
                return ext.getName() != null && ext.getName().startsWith(prefix);
            }

            public String toString() {
                return "nameStartsWith(" + prefix + ")";
            }
        };
    }

    public static Predicate<KeyPair> nameEquals(final String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must be defined");
        return new Predicate<KeyPair>(){

            public boolean apply(KeyPair ext) {
                return ext.getName() != null && ext.getName().equals(name);
            }

            public String toString() {
                return "nameEquals(" + name + ")";
            }
        };
    }
}

