/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.domain;

import com.google.common.base.Objects;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.jclouds.openstack.domain.Link;
import org.jclouds.openstack.domain.Resource;

public class Extension
extends Resource {
    private URI namespace;
    private String alias;
    private Date updated;
    private String description;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Extension.builder().fromExtension(this);
    }

    protected Extension(String name, Set<Link> links, URI namespace, String alias, Date updated, String description) {
        super(alias, name, links);
        this.namespace = namespace;
        this.alias = alias;
        this.updated = updated;
        this.description = description;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("id", (Object)this.getId()).add("name", (Object)this.name).add("links", (Object)this.links).add("namespace", (Object)this.namespace).add("alias", (Object)this.alias).add("updated", (Object)this.updated).add("description", (Object)this.description).toString();
    }

    public static class Builder
    extends Resource.Builder {
        private URI namespace;
        private String alias;
        private Date updated;
        private String description;

        public Builder namespace(URI namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Extension build() {
            return new Extension(this.name, this.links, this.namespace, this.alias, this.updated, this.description);
        }

        public Builder fromExtension(Extension in) {
            return this.fromResource(in).namespace(in.getNamespace()).alias(in.getAlias()).updated(in.getUpdated()).description(in.getDescription());
        }

        public Builder id(String id) {
            return this.alias(id);
        }

        public Builder name(String name) {
            return (Builder)((Object)Builder.class.cast(super.name(name)));
        }

        public Builder links(Set<Link> links) {
            return (Builder)((Object)Builder.class.cast(super.links(links)));
        }

        public Builder fromResource(Resource in) {
            return (Builder)((Object)Builder.class.cast(super.fromResource(in)));
        }
    }
}

