/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v1_1.domain.Address;
import org.jclouds.openstack.nova.v1_1.domain.Server;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ServerInZone;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ZoneAndId;

public class ServerInZoneToNodeMetadata
implements Function<ServerInZone, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Map<String, Location>> locationIndex;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final GroupNamingConvention nodeNamingConvention;
    public static final Predicate<String> isInet4Address = new Predicate<String>(){

        public boolean apply(String input) {
            try {
                return InetAddresses.forString((String)input) instanceof Inet4Address;
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }
    };

    @Inject
    public ServerInZoneToNodeMetadata(Supplier<Map<String, Location>> locationIndex, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.locationIndex = (Supplier)Preconditions.checkNotNull(locationIndex, (Object)"locationIndex");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares");
    }

    public NodeMetadata apply(ServerInZone serverInZone) {
        Location zone = (Location)((Map)this.locationIndex.get()).get(serverInZone.getZone());
        Preconditions.checkState((zone != null ? 1 : 0) != 0, (String)"location %s not in locationIndex: %s", (Object[])new Object[]{serverInZone.getZone(), this.locationIndex.get()});
        Server from = serverInZone.getServer();
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.id(serverInZone.slashEncode());
        builder.providerId(from.getId());
        builder.name(from.getName());
        builder.hostname(from.getName());
        builder.location(from.getHostId() != null ? new LocationBuilder().scope(LocationScope.HOST).id(from.getHostId()).description(from.getHostId()).parent(zone).build() : zone);
        builder.userMetadata(from.getMetadata());
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getName()));
        builder.imageId(ZoneAndId.fromZoneAndId(serverInZone.getZone(), from.getImage().getId()).slashEncode());
        builder.operatingSystem(this.findOperatingSystemForServerOrNull(serverInZone));
        builder.hardware(this.findHardwareForServerOrNull(serverInZone));
        builder.state(from.getStatus().getNodeState());
        builder.publicAddresses(Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.concat(from.getPublicAddresses(), from.getInternetAddresses()), (Function)AddressToStringTransformationFunction.INSTANCE), isInet4Address));
        builder.privateAddresses(Iterables.filter((Iterable)Iterables.transform(from.getPrivateAddresses(), (Function)AddressToStringTransformationFunction.INSTANCE), isInet4Address));
        return builder.build();
    }

    protected Hardware findHardwareForServerOrNull(ServerInZone serverInZone) {
        return (Hardware)this.findObjectOfTypeForServerOrNull((Set)this.hardwares.get(), "hardware", serverInZone.getServer().getFlavor().getId(), serverInZone);
    }

    protected OperatingSystem findOperatingSystemForServerOrNull(ServerInZone serverInZone) {
        Image image = (Image)this.findObjectOfTypeForServerOrNull((Set)this.images.get(), "image", serverInZone.getServer().getImage().getId(), serverInZone);
        return image != null ? image.getOperatingSystem() : null;
    }

    public <T extends ComputeMetadata> T findObjectOfTypeForServerOrNull(Set<? extends T> supply, String type, final String objectId, final ZoneAndId serverInZone) {
        try {
            return (T)((ComputeMetadata)Iterables.find(supply, (Predicate)new Predicate<T>(){

                public boolean apply(T input) {
                    return input.getId().equals(ZoneAndId.fromZoneAndId(serverInZone.getZone(), objectId).slashEncode());
                }
            }));
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find %s with id(%s) for server(%s)", new Object[]{type, objectId, serverInZone});
            return null;
        }
    }

    private static enum AddressToStringTransformationFunction implements Function<Address, String>
    {
        INSTANCE;


        public String apply(Address address) {
            return address.getAddr();
        }
    }
}

