/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.extensions;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v1_1.domain.FloatingIP;
import org.jclouds.openstack.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/floating_ips/api/v1.1")
@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface FloatingIPAsyncClient {
    @GET
    @Path(value="/os-floating-ips")
    @SelectJson(value="floating_ips")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<FloatingIP>> listFloatingIPs();

    @GET
    @Path(value="/os-floating-ips/{id}")
    @SelectJson(value="floating_ip")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<FloatingIP> getFloatingIP(@PathParam(value="id") String var1);

    @POST
    @Path(value="/os-floating-ips")
    @SelectJson(value="floating_ip")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Payload(value="{}")
    public ListenableFuture<FloatingIP> allocate();

    @DELETE
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/os-floating-ips/{id}")
    public ListenableFuture<Void> deallocate(@PathParam(value="id") String var1);

    @POST
    @Path(value="/servers/{server}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"addFloatingIp\":%7B\"address\":\"{address}\"%7D%7D")
    public ListenableFuture<Void> addFloatingIPToServer(@PayloadParam(value="address") String var1, @PathParam(value="server") String var2);

    @POST
    @Path(value="/servers/{server}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"removeFloatingIp\":%7B\"address\":\"{address}\"%7D%7D")
    public ListenableFuture<Void> removeFloatingIPFromServer(@PayloadParam(value="address") String var1, @PathParam(value="server") String var2);
}

