/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1;

import com.google.common.base.Optional;
import com.google.inject.Provides;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.concurrent.Timeout;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Zone;
import org.jclouds.location.functions.ZoneToEndpoint;
import org.jclouds.openstack.nova.v1_1.extensions.AdminActionsClient;
import org.jclouds.openstack.nova.v1_1.extensions.FlavorExtraSpecsClient;
import org.jclouds.openstack.nova.v1_1.extensions.FloatingIPClient;
import org.jclouds.openstack.nova.v1_1.extensions.HostAdministrationClient;
import org.jclouds.openstack.nova.v1_1.extensions.HostAggregateClient;
import org.jclouds.openstack.nova.v1_1.extensions.KeyPairClient;
import org.jclouds.openstack.nova.v1_1.extensions.QuotaClassClient;
import org.jclouds.openstack.nova.v1_1.extensions.QuotaClient;
import org.jclouds.openstack.nova.v1_1.extensions.SecurityGroupClient;
import org.jclouds.openstack.nova.v1_1.extensions.ServerWithSecurityGroupsClient;
import org.jclouds.openstack.nova.v1_1.extensions.SimpleTenantUsageClient;
import org.jclouds.openstack.nova.v1_1.extensions.VirtualInterfaceClient;
import org.jclouds.openstack.nova.v1_1.extensions.VolumeClient;
import org.jclouds.openstack.nova.v1_1.extensions.VolumeTypeClient;
import org.jclouds.openstack.nova.v1_1.features.ExtensionClient;
import org.jclouds.openstack.nova.v1_1.features.FlavorClient;
import org.jclouds.openstack.nova.v1_1.features.ImageClient;
import org.jclouds.openstack.nova.v1_1.features.ServerClient;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;

@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface NovaClient {
    @Provides
    @Zone
    public Set<String> getConfiguredZones();

    @Delegate
    public ServerClient getServerClientForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public FlavorClient getFlavorClientForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public ExtensionClient getExtensionClientForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public ImageClient getImageClientForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<FloatingIPClient> getFloatingIPExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<SecurityGroupClient> getSecurityGroupExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<KeyPairClient> getKeyPairExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<HostAdministrationClient> getHostAdministrationExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<SimpleTenantUsageClient> getSimpleTenantUsageExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<VolumeClient> getVolumeExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<VirtualInterfaceClient> getVirtualInterfaceExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<ServerWithSecurityGroupsClient> getServerWithSecurityGroupsExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<AdminActionsClient> getAdminActionsExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<HostAggregateClient> getHostAggregateExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<FlavorExtraSpecsClient> getFlavorExtraSpecsExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<QuotaClient> getQuotaExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<QuotaClassClient> getQuotaClassExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);

    @Delegate
    public Optional<VolumeTypeClient> getVolumeTypeExtensionForZone(@EndpointParam(parser=ZoneToEndpoint.class) @Nullable String var1);
}

