/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.compute;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.Zone;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v1_1.NovaClient;
import org.jclouds.openstack.nova.v1_1.compute.functions.RemoveFloatingIpFromNodeAndDeallocate;
import org.jclouds.openstack.nova.v1_1.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v1_1.domain.Flavor;
import org.jclouds.openstack.nova.v1_1.domain.Image;
import org.jclouds.openstack.nova.v1_1.domain.KeyPair;
import org.jclouds.openstack.nova.v1_1.domain.RebootType;
import org.jclouds.openstack.nova.v1_1.domain.Server;
import org.jclouds.openstack.nova.v1_1.domain.ServerCreated;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.FlavorInZone;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ImageInZone;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ServerInZone;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v1_1.extensions.AdminActionsClient;
import org.jclouds.openstack.nova.v1_1.options.CreateServerOptions;
import org.jclouds.openstack.nova.v1_1.predicates.ImagePredicates;

public class NovaComputeServiceAdapter
implements ComputeServiceAdapter<ServerInZone, FlavorInZone, ImageInZone, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaClient novaClient;
    protected final Supplier<Set<String>> zoneIds;
    protected final RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate;
    protected final LoadingCache<ZoneAndName, KeyPair> keyPairCache;

    @Inject
    public NovaComputeServiceAdapter(NovaClient novaClient, @Zone Supplier<Set<String>> zoneIds, RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate, LoadingCache<ZoneAndName, KeyPair> keyPairCache) {
        this.novaClient = (NovaClient)Preconditions.checkNotNull((Object)novaClient, (Object)"novaClient");
        this.zoneIds = (Supplier)Preconditions.checkNotNull(zoneIds, (Object)"zoneIds");
        this.removeFloatingIpFromNodeAndDeallocate = (RemoveFloatingIpFromNodeAndDeallocate)Preconditions.checkNotNull((Object)removeFloatingIpFromNodeAndDeallocate, (Object)"removeFloatingIpFromNodeAndDeallocate");
        this.keyPairCache = (LoadingCache)Preconditions.checkNotNull(keyPairCache, (Object)"keyPairCache");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerInZone> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder();
        NovaTemplateOptions templateOptions = (NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class);
        CreateServerOptions options = new CreateServerOptions();
        options.metadata(ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue((TemplateOptions)template.getOptions()));
        options.securityGroupNames(templateOptions.getSecurityGroupNames());
        options.userData(templateOptions.getUserData());
        Optional privateKey = Optional.absent();
        if (templateOptions.getKeyPairName() != null) {
            options.keyPairName(templateOptions.getKeyPairName());
            KeyPair keyPair = (KeyPair)this.keyPairCache.getIfPresent((Object)ZoneAndName.fromZoneAndName(template.getLocation().getId(), templateOptions.getKeyPairName()));
            if (keyPair != null && keyPair.getPrivateKey() != null) {
                privateKey = Optional.of((Object)keyPair.getPrivateKey());
                credentialsBuilder.privateKey((String)privateKey.get());
            }
        }
        String zoneId = template.getLocation().getId();
        String imageId = template.getImage().getProviderId();
        String flavorId = template.getHardware().getProviderId();
        this.logger.debug(">> creating new server zone(%s) name(%s) image(%s) flavor(%s) options(%s)", new Object[]{zoneId, name, imageId, flavorId, options});
        ServerCreated lightweightServer = this.novaClient.getServerClientForZone(zoneId).createServer(name, imageId, flavorId, options);
        Server server = this.novaClient.getServerClientForZone(zoneId).getServer(lightweightServer.getId());
        this.logger.trace("<< server(%s)", new Object[]{server.getId()});
        ServerInZone serverInZone = new ServerInZone(server, zoneId);
        if (!privateKey.isPresent()) {
            credentialsBuilder.password(lightweightServer.getAdminPass());
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)serverInZone, serverInZone.slashEncode(), credentialsBuilder.build());
    }

    public Iterable<FlavorInZone> listHardwareProfiles() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String zoneId : (Set)this.zoneIds.get()) {
            builder.addAll(Iterables.transform(this.novaClient.getFlavorClientForZone(zoneId).listFlavorsInDetail(), (Function)new Function<Flavor, FlavorInZone>(){

                public FlavorInZone apply(Flavor arg0) {
                    return new FlavorInZone(arg0, zoneId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<ImageInZone> listImages() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String zoneId : (Set)this.zoneIds.get()) {
            builder.addAll(Iterables.transform((Iterable)Iterables.filter(this.novaClient.getImageClientForZone(zoneId).listImagesInDetail(), ImagePredicates.statusEquals(Image.Status.ACTIVE)), (Function)new Function<Image, ImageInZone>(){

                public ImageInZone apply(Image arg0) {
                    return new ImageInZone(arg0, zoneId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<ServerInZone> listNodes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String zoneId : (Set)this.zoneIds.get()) {
            builder.addAll(Iterables.transform(this.novaClient.getServerClientForZone(zoneId).listServersInDetail(), (Function)new Function<Server, ServerInZone>(){

                public ServerInZone apply(Server arg0) {
                    return new ServerInZone(arg0, zoneId);
                }
            }));
        }
        return builder.build();
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public ServerInZone getNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        Server server = this.novaClient.getServerClientForZone(zoneAndId.getZone()).getServer(zoneAndId.getId());
        return server == null ? null : new ServerInZone(server, zoneAndId.getZone());
    }

    public void destroyNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        if (this.novaClient.getFloatingIPExtensionForZone(zoneAndId.getZone()).isPresent()) {
            try {
                this.removeFloatingIpFromNodeAndDeallocate.apply(zoneAndId);
            }
            catch (RuntimeException e) {
                this.logger.warn((Throwable)e, "<< error removing and deallocating ip from node(%s): %s", new Object[]{id, e.getMessage()});
            }
        }
        this.novaClient.getServerClientForZone(zoneAndId.getZone()).deleteServer(zoneAndId.getId());
    }

    public void rebootNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        this.novaClient.getServerClientForZone(zoneAndId.getZone()).rebootServer(zoneAndId.getId(), RebootType.HARD);
    }

    public void resumeNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        if (this.novaClient.getAdminActionsExtensionForZone(zoneAndId.getZone()).isPresent()) {
            ((AdminActionsClient)this.novaClient.getAdminActionsExtensionForZone(zoneAndId.getZone()).get()).resumeServer(zoneAndId.getId());
        }
        throw new UnsupportedOperationException("resume requires installation of the Admin Actions extension");
    }

    public void suspendNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        if (this.novaClient.getAdminActionsExtensionForZone(zoneAndId.getZone()).isPresent()) {
            ((AdminActionsClient)this.novaClient.getAdminActionsExtensionForZone(zoneAndId.getZone()).get()).suspendServer(zoneAndId.getId());
        }
        throw new UnsupportedOperationException("suspend requires installation of the Admin Actions extension");
    }
}

