/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.compute.extensions;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.concurrent.Futures;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v1_1.NovaClient;
import org.jclouds.openstack.nova.v1_1.domain.Server;
import org.jclouds.openstack.nova.v1_1.domain.zonescoped.ZoneAndId;
import org.jclouds.predicates.PredicateWithResult;
import org.jclouds.predicates.Retryables;

@Singleton
public class NovaImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final NovaClient novaClient;
    private final ExecutorService executor;
    @Inject(optional=true)
    @Named(value="IMAGE_MAX_WAIT")
    private long maxWait = 3600L;
    @Inject(optional=true)
    @Named(value="IMAGE_WAIT_PERIOD")
    private long waitPeriod = 1L;
    private PredicateWithResult<ZoneAndId, Image> imageReadyPredicate;

    @javax.inject.Inject
    public NovaImageExtension(NovaClient novaClient, @Named(value="jclouds.user-threads") ExecutorService userThreads, PredicateWithResult<ZoneAndId, Image> imageReadyPredicate) {
        this.novaClient = (NovaClient)Preconditions.checkNotNull((Object)novaClient);
        this.executor = userThreads;
        this.imageReadyPredicate = imageReadyPredicate;
    }

    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        Server server = this.novaClient.getServerClientForZone(zoneAndId.getZone()).getServer(zoneAndId.getId());
        if (server == null) {
            throw new NoSuchElementException("Cannot find server with id: " + zoneAndId);
        }
        CloneImageTemplate template = new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name).build();
        return template;
    }

    public ListenableFuture<Image> createImage(ImageTemplate template) {
        Preconditions.checkState((boolean)(template instanceof CloneImageTemplate), (Object)" openstack-nova only supports creating images through cloning.");
        CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        ZoneAndId sourceImageZoneAndId = ZoneAndId.fromSlashEncoded(cloneTemplate.getSourceNodeId());
        String newImageId = this.novaClient.getServerClientForZone(sourceImageZoneAndId.getZone()).createImageFromServer(cloneTemplate.getName(), sourceImageZoneAndId.getId());
        final ZoneAndId targetImageZoneAndId = ZoneAndId.fromZoneAndId(sourceImageZoneAndId.getZone(), newImageId);
        this.logger.info(">> Registered new Image %s, waiting for it to become available.", new Object[]{newImageId});
        return Futures.makeListenable(this.executor.submit(new Callable<Image>(){

            @Override
            public Image call() throws Exception {
                return (Image)Retryables.retryGettingResultOrFailing((PredicateWithResult)NovaImageExtension.this.imageReadyPredicate, (Object)targetImageZoneAndId, (long)NovaImageExtension.this.maxWait, (long)NovaImageExtension.this.waitPeriod, (TimeUnit)TimeUnit.SECONDS, (String)("Image was not created within the time limit, Giving up! [Limit: " + NovaImageExtension.this.maxWait + " secs.]"));
            }
        }), (ExecutorService)this.executor);
    }

    public boolean deleteImage(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        try {
            this.novaClient.getImageClientForZone(zoneAndId.getZone()).deleteImage(zoneAndId.getId());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

