/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.config;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v1_1.domain.HostResourceUsage;
import org.jclouds.openstack.nova.v1_1.domain.Server;
import org.jclouds.openstack.nova.v1_1.domain.ServerExtendedAttributes;
import org.jclouds.openstack.nova.v1_1.domain.ServerExtendedStatus;
import org.jclouds.openstack.nova.v1_1.domain.ServerWithSecurityGroups;

public class NovaParserModule
extends AbstractModule {
    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings() {
        return ImmutableMap.of(HostResourceUsage.class, (Object)new HostResourceUsageAdapter(), ServerWithSecurityGroups.class, (Object)new ServerWithSecurityGroupsAdapter(), Server.class, (Object)new ServerAdapter());
    }

    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    @Singleton
    public static class ServerAdapter
    implements JsonDeserializer<Server> {
        public Server deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            ServerExtendedAttributes extraAttributes;
            Server serverBase = this.apply((ServerInternal)((Object)context.deserialize(jsonElement, ServerInternal.class)));
            Object result = Server.builder().fromServer(serverBase);
            ServerExtendedStatus extendedStatus = (ServerExtendedStatus)context.deserialize(jsonElement, ServerExtendedStatus.class);
            if (!Objects.equal((Object)extendedStatus, (Object)ServerExtendedStatus.builder().build())) {
                ((Server.Builder)((Object)result)).extendedStatus(extendedStatus);
            }
            if (!Objects.equal((Object)(extraAttributes = (ServerExtendedAttributes)context.deserialize(jsonElement, ServerExtendedAttributes.class)), (Object)ServerExtendedAttributes.builder().build())) {
                ((Server.Builder)((Object)result)).extraAttributes(extraAttributes);
            }
            return ((Server.Builder)((Object)result)).build();
        }

        public Server apply(ServerInternal in) {
            return in.toBuilder().build();
        }

        private static class ServerInternal
        extends Server {
            protected ServerInternal() {
            }
        }
    }

    @Singleton
    public static class ServerWithSecurityGroupsAdapter
    implements JsonDeserializer<ServerWithSecurityGroups> {
        public ServerWithSecurityGroups deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            Server server = (Server)((Object)context.deserialize(jsonElement, Server.class));
            ServerWithSecurityGroups.Builder result = (ServerWithSecurityGroups.Builder)((Object)ServerWithSecurityGroups.builder().fromServer(server));
            LinkedHashSet names = Sets.newLinkedHashSet();
            if (jsonElement.getAsJsonObject().get("security_groups") != null) {
                JsonArray x = jsonElement.getAsJsonObject().get("security_groups").getAsJsonArray();
                for (JsonElement y : x) {
                    names.add(y.getAsJsonObject().get("name").getAsString());
                }
                result.securityGroupNames(names);
            }
            return result.build();
        }
    }

    @Singleton
    public static class HostResourceUsageAdapter
    implements JsonSerializer<HostResourceUsage>,
    JsonDeserializer<HostResourceUsage> {
        public HostResourceUsage apply(HostResourceUsageView in) {
            return in.resource.toBuilder().build();
        }

        public HostResourceUsage deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            return this.apply((HostResourceUsageView)context.deserialize(jsonElement, HostResourceUsageView.class));
        }

        public JsonElement serialize(HostResourceUsage hostResourceUsage, Type type, JsonSerializationContext context) {
            return context.serialize((Object)hostResourceUsage);
        }

        private static class HostResourceUsageInternal
        extends HostResourceUsage {
            protected HostResourceUsageInternal(HostResourceUsage.Builder<?> builder) {
                super(builder);
            }
        }

        private static class HostResourceUsageView {
            protected HostResourceUsageInternal resource;

            private HostResourceUsageView() {
            }
        }
    }
}

