/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v1_1.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.OnlyLocationOrFirstZone;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.nova.v1_1.NovaAsyncClient;
import org.jclouds.openstack.nova.v1_1.NovaClient;
import org.jclouds.openstack.nova.v1_1.config.NovaParserModule;
import org.jclouds.openstack.nova.v1_1.domain.Extension;
import org.jclouds.openstack.nova.v1_1.extensions.AdminActionsAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.AdminActionsClient;
import org.jclouds.openstack.nova.v1_1.extensions.FlavorExtraSpecsAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.FlavorExtraSpecsClient;
import org.jclouds.openstack.nova.v1_1.extensions.FloatingIPAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.FloatingIPClient;
import org.jclouds.openstack.nova.v1_1.extensions.HostAdministrationAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.HostAdministrationClient;
import org.jclouds.openstack.nova.v1_1.extensions.HostAggregateAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.HostAggregateClient;
import org.jclouds.openstack.nova.v1_1.extensions.KeyPairAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.KeyPairClient;
import org.jclouds.openstack.nova.v1_1.extensions.QuotaAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.QuotaClassAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.QuotaClassClient;
import org.jclouds.openstack.nova.v1_1.extensions.QuotaClient;
import org.jclouds.openstack.nova.v1_1.extensions.SecurityGroupAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.SecurityGroupClient;
import org.jclouds.openstack.nova.v1_1.extensions.ServerWithSecurityGroupsAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.ServerWithSecurityGroupsClient;
import org.jclouds.openstack.nova.v1_1.extensions.SimpleTenantUsageAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.SimpleTenantUsageClient;
import org.jclouds.openstack.nova.v1_1.extensions.VirtualInterfaceAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.VirtualInterfaceClient;
import org.jclouds.openstack.nova.v1_1.extensions.VolumeAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.VolumeClient;
import org.jclouds.openstack.nova.v1_1.extensions.VolumeTypeAsyncClient;
import org.jclouds.openstack.nova.v1_1.extensions.VolumeTypeClient;
import org.jclouds.openstack.nova.v1_1.features.ExtensionAsyncClient;
import org.jclouds.openstack.nova.v1_1.features.ExtensionClient;
import org.jclouds.openstack.nova.v1_1.features.FlavorAsyncClient;
import org.jclouds.openstack.nova.v1_1.features.FlavorClient;
import org.jclouds.openstack.nova.v1_1.features.ImageAsyncClient;
import org.jclouds.openstack.nova.v1_1.features.ImageClient;
import org.jclouds.openstack.nova.v1_1.features.ServerAsyncClient;
import org.jclouds.openstack.nova.v1_1.features.ServerClient;
import org.jclouds.openstack.nova.v1_1.functions.PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet;
import org.jclouds.openstack.nova.v1_1.handlers.NovaErrorHandler;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.functions.ImplicitOptionalConverter;

@ConfiguresRestClient
public class NovaRestClientModule
extends RestClientModule<NovaClient, NovaAsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(ServerClient.class, ServerAsyncClient.class).put(FlavorClient.class, FlavorAsyncClient.class).put(ImageClient.class, ImageAsyncClient.class).put(ExtensionClient.class, ExtensionAsyncClient.class).put(FloatingIPClient.class, FloatingIPAsyncClient.class).put(SecurityGroupClient.class, SecurityGroupAsyncClient.class).put(KeyPairClient.class, KeyPairAsyncClient.class).put(HostAdministrationClient.class, HostAdministrationAsyncClient.class).put(SimpleTenantUsageClient.class, SimpleTenantUsageAsyncClient.class).put(VolumeClient.class, VolumeAsyncClient.class).put(VirtualInterfaceClient.class, VirtualInterfaceAsyncClient.class).put(ServerWithSecurityGroupsClient.class, ServerWithSecurityGroupsAsyncClient.class).put(AdminActionsClient.class, AdminActionsAsyncClient.class).put(HostAggregateClient.class, HostAggregateAsyncClient.class).put(FlavorExtraSpecsClient.class, FlavorExtraSpecsAsyncClient.class).put(QuotaClient.class, QuotaAsyncClient.class).put(QuotaClassClient.class, QuotaClassAsyncClient.class).put(VolumeTypeClient.class, VolumeTypeAsyncClient.class).build();

    public NovaRestClientModule() {
        super(DELEGATE_MAP);
    }

    protected void configure() {
        this.install((Module)new NovaParserModule());
        this.bind(ImplicitOptionalConverter.class).to(PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet.class);
        super.configure();
    }

    protected void installLocations() {
        super.installLocations();
        this.install(KeystoneAuthenticationModule.forZones());
        this.bind(ImplicitLocationSupplier.class).to(OnlyLocationOrFirstZone.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public LoadingCache<String, Set<Extension>> provideExtensionsByZone(final Provider<NovaClient> novaClient) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Set<Extension>>(){

            public Set<Extension> load(String key) throws Exception {
                return ((NovaClient)novaClient.get()).getExtensionClientForZone(key).listExtensions();
            }
        });
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(NovaErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(NovaErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(NovaErrorHandler.class);
    }
}

